/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.handlers;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import toolbox.common.Config;
import toolbox.common.handlers.WorldListener;
import toolbox.common.items.ItemSchematic;
import toolbox.common.items.ModItems;

public class WorldHandler {
    Random rand = new Random();

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().func_73046_m() != null) {
            event.getWorld().func_72954_a((IWorldEventListener)new WorldListener(event.getWorld(), event.getWorld().func_73046_m()));
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ItemStack book;
            NBTTagCompound persistedTag;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            boolean giveBook = false;
            boolean giveSchematics = false;
            NBTTagCompound playerData = player.getEntityData();
            if (!playerData.func_150297_b("PlayerPersisted", 10)) {
                playerData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            if (!(persistedTag = playerData.func_74775_l("PlayerPersisted")).func_74764_b("received_at_book")) {
                giveBook = Config.SPAWN_WITH_BOOK;
                persistedTag.func_74757_a("received_at_book", giveBook);
            }
            if (!persistedTag.func_74764_b("received_at_schematics")) {
                giveSchematics = Config.ENABLE_SCHEMATICS && !Config.SPAWN_SCHEMATICS.isEmpty();
                persistedTag.func_74757_a("received_at_schematics", giveSchematics);
            }
            if (giveBook && !player.field_71071_by.func_70441_a(book = new ItemStack((Item)ModItems.guide_book))) {
                player.func_71019_a(book, false);
            }
            if (giveSchematics && ModItems.schematic != null) {
                for (String type : Config.SPAWN_SCHEMATICS) {
                    if (!ItemSchematic.subtypes.contains(type)) continue;
                    ItemStack schematic = new ItemStack((Item)ModItems.schematic);
                    NBTTagCompound typeTag = new NBTTagCompound();
                    typeTag.func_74778_a("Type", type);
                    schematic.func_77982_d(typeTag);
                    if (player.field_71071_by.func_70441_a(schematic)) continue;
                    player.func_71019_a(schematic, false);
                }
            }
        }
    }
}

