/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.items.parts;

import api.materials.HeadMaterial;
import api.materials.Materials;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import toolbox.common.Config;
import toolbox.common.items.parts.ItemToolPart;
import toolbox.common.recipes.ModRecipes;

public class ItemToolHead
extends ItemToolPart {
    public Map<Integer, HeadMaterial> meta_map = new HashMap<Integer, HeadMaterial>();

    protected void initMats() {
        int i = 0;
        for (HeadMaterial mat : Materials.head_registry.values()) {
            this.meta_map.put(i, mat);
            ++i;
        }
    }

    public ItemToolHead(String name) {
        super(name);
        this.initMats();
        this.registerMatRecipes();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (int i = 0; i < this.meta_map.size(); ++i) {
            if (Config.HIDE_UNCRAFTABLE_HEADS && (OreDictionary.getOres((String)this.meta_map.get(i).getCraftingItem()).size() <= 0 || OreDictionary.getOres((String)this.meta_map.get(i).getSmallCraftingItem()).size() <= 0)) continue;
            ItemStack stack = new ItemStack((Item)this, 1, i);
            if (!this.func_194125_a(tab)) continue;
            subItems.add((Object)stack);
        }
    }

    public String func_77653_i(ItemStack stack) {
        HeadMaterial mat = this.meta_map.get(stack.func_77960_j());
        if (mat == null) {
            return super.func_77653_i(stack);
        }
        return I18n.func_74838_a((String)(mat.getName() + ".name")) + " " + super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i : this.meta_map.keySet()) {
            String domain = this.meta_map.get(i).getModId();
            String path = "th_" + this.getRegistryName().func_110623_a();
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(domain + ":" + path + "_" + this.meta_map.get(i).getName(), "inventory"));
        }
    }

    public HeadMaterial getMatFromMeta(int meta) {
        return this.meta_map.get(meta);
    }

    public HeadMaterial getMatFromMeta(ItemStack stack) {
        return this.meta_map.get(stack.func_77960_j());
    }

    public void registerMatRecipes() {
        for (int i : this.meta_map.keySet()) {
            ModRecipes.head_map.put(new ItemStack((Item)this, 1, i), this.meta_map.get(i));
        }
    }
}

