/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.items.tools;

import api.materials.Materials;
import betterwithmods.module.hardcore.creatures.HCEnchanting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.items.IWarpingGear;
import toolbox.Toolbox;
import toolbox.common.Config;
import toolbox.common.items.tools.IAdornedTool;
import toolbox.common.items.tools.IBladeTool;
import toolbox.common.items.tools.IHandleTool;
import toolbox.common.materials.ModMaterials;

@Optional.Interface(iface="thaumcraft.api.items.IWarpingGear", modid="thaumcraft")
public class ItemATDagger
extends ItemSword
implements IWarpingGear,
IBladeTool,
IHandleTool,
IAdornedTool {
    private String name = "dagger";
    public static final String DAMAGE_TAG = "Damage";

    public ItemATDagger() {
        super(ModMaterials.TOOL_MAT_TOOLBOX);
        this.setRegistryName(this.name);
        this.func_77655_b("toolbox." + this.name);
        this.field_77777_bU = 1;
        this.func_77637_a(Toolbox.weaponsTab);
        this.func_77656_e(0);
    }

    public int getDurability(ItemStack stack) {
        return (int)((float)IBladeTool.getBladeMat(stack).getDurability() * IHandleTool.getHandleMat(stack).getDurabilityMod() * IAdornedTool.getAdornmentMat(stack).getDurabilityMod() * 0.75f);
    }

    public float getEfficiencyMod(ItemStack stack) {
        return (IAdornedTool.getAdornmentMat(stack).getEfficiencyMod() * IHandleTool.getHandleMat(stack).getEfficiencyMod() - 1.0f) * 0.25f;
    }

    public float getAttackDamage(ItemStack stack) {
        return IBladeTool.getBladeMat(stack).getAttackDamage() + IAdornedTool.getAdornmentMat(stack).getAttackDamageMod();
    }

    public int getEnchantability(ItemStack stack) {
        return (int)((float)IBladeTool.getBladeMat(stack).getEnchantability() * IAdornedTool.getAdornmentMat(stack).getEnchantabilityMod() * IHandleTool.getHandleMat(stack).getEnchantabilityMod());
    }

    public ItemStack getRepairItem(ItemStack stack) {
        return IBladeTool.getBladeMat(stack).getRepairItem();
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150321_G;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getEnchantability(stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.getRepairItem(toRepair);
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        if (toRepair.func_77973_b() == this && OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)IBladeTool.getBladeMat(toRepair).getCraftingItem()), (ItemStack[])new ItemStack[]{repair})) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(3.0f + this.getAttackDamage(stack)) * (double)0.66667f, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -1.8000000953674316 + (double)this.getEfficiencyMod(stack), 0));
        }
        return multimap;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamage(stack) / (double)this.getDurability(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getDurability(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!Config.DISABLED_TOOLS.contains("dagger")) {
            ItemStack stack1 = new ItemStack((Item)this);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Blade", Materials.randomHead().getName());
            tag.func_74778_a("Handle", Materials.randomHandle().getName());
            tag.func_74778_a("ADORNMENT", Materials.randomAdornment().getName());
            stack1.func_77982_d(tag);
            if (this.func_194125_a(tab)) {
                subItems.add((Object)stack1);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(IBladeTool.getBladeMat(stack).getName() + ".name")) + " " + super.func_77653_i(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (IBladeTool.getBladeMat(stack) == ModMaterials.HEAD_SOULFORGED_STEEL && Loader.isModLoaded((String)"betterwithmods") && !HCEnchanting.canEnchantSteel((Enchantment)enchantment)) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b()) || enchantment.field_77351_y == EnumEnchantmentType.WEAPON;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        return IBladeTool.getBladeMat(stack) == ModMaterials.HEAD_VOID ? 1 : 0;
    }
}

