/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.items.tools;

import api.materials.Materials;
import betterwithmods.module.hardcore.creatures.HCEnchanting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.items.IWarpingGear;
import toolbox.Toolbox;
import toolbox.common.Config;
import toolbox.common.items.tools.IAdornedTool;
import toolbox.common.items.tools.IHaftTool;
import toolbox.common.items.tools.IHandleTool;
import toolbox.common.items.tools.IHeadTool;
import toolbox.common.materials.ModMaterials;

@Optional.Interface(iface="thaumcraft.api.items.IWarpingGear", modid="thaumcraft")
public class ItemATHammer
extends ItemPickaxe
implements IWarpingGear,
IHeadTool,
IHaftTool,
IHandleTool,
IAdornedTool {
    private String toolClass = "pickaxe";
    private String name = "hammer";
    public static final String DAMAGE_TAG = "Damage";

    public ItemATHammer() {
        super(ModMaterials.TOOL_MAT_TOOLBOX);
        this.setRegistryName(this.name);
        this.func_77655_b("toolbox." + this.name);
        this.field_77777_bU = 1;
        this.func_77637_a(Toolbox.toolsTab);
        this.func_77656_e(0);
    }

    public int getHarvestLevel(ItemStack stack) {
        return IHeadTool.getHeadMat(stack).getHarvestLevel() + IAdornedTool.getAdornmentMat(stack).getHarvestLevelMod() + IHaftTool.getHaftMat(stack).getHarvestLevelMod();
    }

    public int getDurability(ItemStack stack) {
        return (int)((float)IHeadTool.getHeadMat(stack).getDurability() * IHaftTool.getHaftMat(stack).getDurabilityMod() * IHandleTool.getHandleMat(stack).getDurabilityMod() * IAdornedTool.getAdornmentMat(stack).getDurabilityMod());
    }

    public float getEfficiency(ItemStack stack) {
        return IHeadTool.getHeadMat(stack).getEfficiency() * IAdornedTool.getAdornmentMat(stack).getEfficiencyMod() * IHaftTool.getHaftMat(stack).getEfficiencyMod() * IHandleTool.getHandleMat(stack).getEfficiencyMod() * 0.25f;
    }

    public float getAttackDamage(ItemStack stack) {
        return IHeadTool.getHeadMat(stack).getAttackDamage() + IAdornedTool.getAdornmentMat(stack).getAttackDamageMod() + IHaftTool.getHaftMat(stack).getAttackDamageMod();
    }

    public int getEnchantability(ItemStack stack) {
        return (int)((float)IHeadTool.getHeadMat(stack).getEnchantability() * IHaftTool.getHaftMat(stack).getEnchantabilityMod() * IAdornedTool.getAdornmentMat(stack).getEnchantabilityMod() * IHandleTool.getHandleMat(stack).getEnchantabilityMod());
    }

    public ItemStack getRepairItem(ItemStack stack) {
        return IHeadTool.getHeadMat(stack).getRepairItem();
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state) && state.func_185904_a() != Material.field_151576_e && state.func_185904_a() != Material.field_151573_f) continue;
            return this.getEfficiency(stack);
        }
        return 1.0f;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getEnchantability(stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.getRepairItem(toRepair);
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        if (toRepair.func_77973_b() == this && OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)IHeadTool.getHeadMat(toRepair).getCraftingItem()), (ItemStack[])new ItemStack[]{repair})) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (toolClass != null && this.getToolClasses(stack).contains(toolClass)) {
            return this.getHarvestLevel(stack);
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 9.0 + (double)this.getAttackDamage(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.5, 0));
        }
        return multimap;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamage(stack) / (double)this.getDurability(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getDurability(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!Config.DISABLED_TOOLS.contains("hammer")) {
            ItemStack stack1 = new ItemStack((Item)this);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Head", Materials.randomHead().getName());
            tag.func_74778_a("Haft", Materials.randomHaft().getName());
            tag.func_74778_a("Handle", Materials.randomHandle().getName());
            tag.func_74778_a("ADORNMENT", Materials.randomAdornment().getName());
            stack1.func_77982_d(tag);
            if (this.func_194125_a(tab)) {
                subItems.add((Object)stack1);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(IHeadTool.getHeadMat(stack).getName() + ".name")) + " " + super.func_77653_i(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (IHeadTool.getHeadMat(stack) == ModMaterials.HEAD_SOULFORGED_STEEL && Loader.isModLoaded((String)"betterwithmods") && !HCEnchanting.canEnchantSteel((Enchantment)enchantment)) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b()) || enchantment.field_77351_y == EnumEnchantmentType.DIGGER;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150343_Z || block == Blocks.field_150450_ax || block == Blocks.field_150439_ay) {
            return this.getHarvestLevel(stack) >= block.getHarvestLevel(state);
        }
        return super.func_150897_b(state);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        RayTraceResult rt;
        World world = player.func_130014_f_();
        if (!world.field_72995_K && player instanceof EntityPlayerMP && (rt = this.func_77621_a(world, player, false)) != null && rt.field_72313_a != null && rt.field_72313_a == RayTraceResult.Type.BLOCK) {
            EnumFacing side = rt.field_178784_b;
            List<BlockPos> extraBlocks = this.getExtraBlocks(world, rt, player, itemstack);
            for (BlockPos pos2 : extraBlocks) {
                IBlockState state = world.func_180495_p(pos2);
                if (!world.func_175667_e(pos2) || !player.func_175151_a(pos2, side, itemstack) || !state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos2, player)) continue;
                if (player.field_71075_bZ.field_75098_d) {
                    state.func_177230_c().func_176208_a(world, pos2, state, player);
                    if (state.func_177230_c().removedByPlayer(state, world, pos2, player, false)) {
                        state.func_177230_c().func_176206_d(world, pos2, state);
                    }
                } else {
                    int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos2);
                    state.func_177230_c().func_176208_a(world, pos2, state, player);
                    this.func_179218_a(itemstack, world, state, pos2, (EntityLivingBase)player);
                    if (state.func_177230_c().removedByPlayer(state, world, pos2, player, true)) {
                        state.func_177230_c().func_176206_d(world, pos2, state);
                        state.func_177230_c().func_180657_a(world, player, pos2, state, world.func_175625_s(pos2), itemstack);
                        state.func_177230_c().func_180637_b(world, pos2, xp);
                    }
                }
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
        }
        return false;
    }

    public RayTraceResult rayTraceBlocks(World world, EntityPlayer player) {
        return this.func_77621_a(world, player, false);
    }

    public List<BlockPos> getExtraBlocks(World world, RayTraceResult rt, EntityPlayer player, ItemStack stack) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (rt == null || rt.func_178782_a() == null || rt.field_178784_b == null) {
            return positions;
        }
        if (player.func_70093_af()) {
            return positions;
        }
        BlockPos pos = rt.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        if (ForgeHooks.canToolHarvestBlock((IBlockAccess)world, (BlockPos)pos, (ItemStack)stack)) {
            switch (rt.field_178784_b.func_176740_k()) {
                case Y: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.NORTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.EAST).func_177972_a(EnumFacing.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.WEST).func_177972_a(EnumFacing.NORTH), stack, positions);
                    break;
                }
                case X: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.NORTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.DOWN).func_177972_a(EnumFacing.NORTH), stack, positions);
                    break;
                }
                case Z: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.DOWN).func_177972_a(EnumFacing.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.EAST).func_177972_a(EnumFacing.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(EnumFacing.WEST).func_177972_a(EnumFacing.DOWN), stack, positions);
                }
            }
        }
        return positions;
    }

    protected void attemptAddExtraBlock(World world, IBlockState state1, BlockPos pos2, ItemStack stack, List<BlockPos> list) {
        IBlockState state2 = world.func_180495_p(pos2);
        if (world.func_175623_d(pos2)) {
            return;
        }
        if (state2.func_177230_c() != state1.func_177230_c() && (state2.func_177230_c() != Blocks.field_150439_ay && state2.func_177230_c() != Blocks.field_150450_ax || state1.func_177230_c() != Blocks.field_150439_ay && state1.func_177230_c() != Blocks.field_150450_ax)) {
            return;
        }
        if (!state2.func_177230_c().isToolEffective(this.toolClass, state2) && !this.canHarvestBlock(state2, stack)) {
            return;
        }
        list.add(pos2);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        return IHeadTool.getHeadMat(stack) == ModMaterials.HEAD_VOID ? 1 : 0;
    }
}

