/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.items.tools;

import api.materials.Materials;
import betterwithmods.module.hardcore.creatures.HCEnchanting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.items.IWarpingGear;
import toolbox.Toolbox;
import toolbox.common.Config;
import toolbox.common.items.tools.IAdornedTool;
import toolbox.common.items.tools.IHaftTool;
import toolbox.common.items.tools.IHandleTool;
import toolbox.common.items.tools.IHeadTool;
import toolbox.common.materials.ModMaterials;

@Optional.Interface(iface="thaumcraft.api.items.IWarpingGear", modid="thaumcraft")
public class ItemATMace
extends ItemSword
implements IWarpingGear,
IHeadTool,
IHaftTool,
IHandleTool,
IAdornedTool {
    private String name = "mace";
    public static final String DAMAGE_TAG = "Damage";

    public ItemATMace() {
        super(ModMaterials.TOOL_MAT_TOOLBOX);
        this.setRegistryName(this.name);
        this.func_77655_b("toolbox." + this.name);
        this.field_77777_bU = 1;
        this.func_77637_a(Toolbox.weaponsTab);
        this.func_77656_e(0);
    }

    public int getDurability(ItemStack stack) {
        return (int)((float)IHeadTool.getHeadMat(stack).getDurability() * IHaftTool.getHaftMat(stack).getDurabilityMod() * IHandleTool.getHandleMat(stack).getDurabilityMod() * IAdornedTool.getAdornmentMat(stack).getDurabilityMod());
    }

    public float getEfficiency(ItemStack stack) {
        return IHeadTool.getHeadMat(stack).getEfficiency() * IAdornedTool.getAdornmentMat(stack).getEfficiencyMod() * IHaftTool.getHaftMat(stack).getEfficiencyMod() * IHandleTool.getHandleMat(stack).getEfficiencyMod();
    }

    public float getAttackDamage(ItemStack stack) {
        return IHeadTool.getHeadMat(stack).getAttackDamage() + IAdornedTool.getAdornmentMat(stack).getAttackDamageMod() + IHaftTool.getHaftMat(stack).getAttackDamageMod();
    }

    public int getEnchantability(ItemStack stack) {
        return (int)((float)IHeadTool.getHeadMat(stack).getEnchantability() * IHaftTool.getHaftMat(stack).getEnchantabilityMod() * IAdornedTool.getAdornmentMat(stack).getEnchantabilityMod() * IHandleTool.getHandleMat(stack).getEnchantabilityMod());
    }

    public ItemStack getRepairItem(ItemStack stack) {
        return IHeadTool.getHeadMat(stack).getRepairItem();
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150321_G;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getEnchantability(stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.getRepairItem(toRepair);
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        if (toRepair.func_77973_b() == this && OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)IHeadTool.getHeadMat(toRepair).getCraftingItem()), (ItemStack[])new ItemStack[]{repair})) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 3.5 + (double)this.getAttackDamage(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.6, 0));
        }
        return multimap;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamage(stack) / (double)this.getDurability(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getDurability(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!Config.DISABLED_TOOLS.contains("mace")) {
            ItemStack stack1 = new ItemStack((Item)this);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Head", Materials.randomHead().getName());
            tag.func_74778_a("Haft", Materials.randomHaft().getName());
            tag.func_74778_a("Handle", Materials.randomHandle().getName());
            tag.func_74778_a("ADORNMENT", Materials.randomAdornment().getName());
            stack1.func_77982_d(tag);
            if (this.func_194125_a(tab)) {
                subItems.add((Object)stack1);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(IHeadTool.getHeadMat(stack).getName() + ".name")) + " " + super.func_77653_i(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (IHeadTool.getHeadMat(stack) == ModMaterials.HEAD_SOULFORGED_STEEL && Loader.isModLoaded((String)"betterwithmods") && !HCEnchanting.canEnchantSteel((Enchantment)enchantment)) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b()) || enchantment.field_77351_y == EnumEnchantmentType.WEAPON;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(stack, target, attacker);
        for (ItemStack armor : target.func_184193_aE()) {
            if (!armor.func_77984_f()) continue;
            if (!(field_77697_d.nextFloat() < 0.3f)) continue;
            armor.func_77972_a((int)(this.getAttackDamage(stack) / 2.0f) + 1, target);
        }
        return true;
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        return IHeadTool.getHeadMat(stack) == ModMaterials.HEAD_VOID ? 1 : 0;
    }
}

