/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.materials;

import api.materials.AdornmentMaterial;
import api.materials.HaftMaterial;
import api.materials.HandleMaterial;
import api.materials.HeadMaterial;
import api.materials.Materials;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import toolbox.common.Config;

public class ModMaterials {
    public static Item.ToolMaterial TOOL_MAT_TOOLBOX;
    public static final HeadMaterial HEAD_WOOD;
    public static final HeadMaterial HEAD_FLINT;
    public static final HeadMaterial HEAD_STONE;
    public static final HeadMaterial HEAD_IRON;
    public static final HeadMaterial HEAD_GOLD;
    public static final HeadMaterial HEAD_COPPER;
    public static final HeadMaterial HEAD_TIN;
    public static final HeadMaterial HEAD_BRONZE;
    public static final HeadMaterial HEAD_ALUMINUM;
    public static final HeadMaterial HEAD_NICKEL;
    public static final HeadMaterial HEAD_LEAD;
    public static final HeadMaterial HEAD_SILVER;
    public static final HeadMaterial HEAD_STEEL;
    public static final HeadMaterial HEAD_ELECTRUM;
    public static final HeadMaterial HEAD_SOULFORGED_STEEL;
    public static final HeadMaterial HEAD_DAWNSTONE;
    public static final HeadMaterial HEAD_CONSTANTAN;
    public static final HeadMaterial HEAD_COBALT;
    public static final HeadMaterial HEAD_ARDITE;
    public static final HeadMaterial HEAD_MANYULLYN;
    public static final HeadMaterial HEAD_THAUMIUM;
    public static final HeadMaterial HEAD_VOID;
    public static final HaftMaterial HAFT_WOOD;
    public static final HaftMaterial HAFT_BONE;
    public static final HaftMaterial HAFT_BLAZE_ROD;
    public static final HaftMaterial HAFT_END_ROD;
    public static final HaftMaterial HAFT_IMPROVED;
    public static final HaftMaterial HAFT_WITHER_BONE;
    public static final HaftMaterial HAFT_TREATED_WOOD;
    public static final HaftMaterial HAFT_WITHERED_BONE;
    public static final HandleMaterial HANDLE_WOOD;
    public static final HandleMaterial HANDLE_BONE;
    public static final HandleMaterial HANDLE_CLOTH;
    public static final HandleMaterial HANDLE_LEATHER;
    public static final HandleMaterial HANDLE_TREATED_WOOD;
    public static final HandleMaterial HANDLE_WITHERED_BONE;
    public static final AdornmentMaterial ADORNMENT_NULL;
    public static final AdornmentMaterial ADORNMENT_DIAMOND;
    public static final AdornmentMaterial ADORNMENT_EMERALD;
    public static final AdornmentMaterial ADORNMENT_QUARTZ;
    public static final AdornmentMaterial ADORNMENT_PRISMARINE;
    public static final AdornmentMaterial ADORNMENT_ENDER_PEARL;
    public static final AdornmentMaterial ADORNMENT_LAPIS;
    public static final AdornmentMaterial ADORNMENT_BIOTITE;
    public static final AdornmentMaterial ADORNMENT_AMETHYST;
    public static final AdornmentMaterial ADORNMENT_RUBY;
    public static final AdornmentMaterial ADORNMENT_PERIDOT;
    public static final AdornmentMaterial ADORNMENT_TOPAZ;
    public static final AdornmentMaterial ADORNMENT_TANZANITE;
    public static final AdornmentMaterial ADORNMENT_MALACHITE;
    public static final AdornmentMaterial ADORNMENT_SAPPHIRE;
    public static final AdornmentMaterial ADORNMENT_AMBER;
    public static final AdornmentMaterial ADORNMENT_OBSIDIAN;
    public static final AdornmentMaterial ADORNMENT_AQUAMARINE;
    public static List<HeadMaterial> headMaterials;

    public static void init() {
        TOOL_MAT_TOOLBOX = EnumHelper.addToolMaterial((String)"toolbox:toolbox", (int)1, (int)1, (float)1.0f, (float)1.0f, (int)1);
        ModMaterials.initHeadMaterials();
        ModMaterials.initHaftMaterials();
        ModMaterials.initHandleMaterials();
        ModMaterials.initAdornmentMaterials();
    }

    private static void initHeadMaterials() {
        OreDictionary.registerOre((String)"flint", (Item)Items.field_151145_ak);
        OreDictionary.registerOre((String)"gravel", (Block)Blocks.field_150351_n);
        headMaterials.add(HEAD_WOOD);
        headMaterials.add(HEAD_FLINT);
        headMaterials.add(HEAD_STONE);
        headMaterials.add(HEAD_IRON);
        headMaterials.add(HEAD_GOLD);
        headMaterials.add(HEAD_COPPER);
        headMaterials.add(HEAD_TIN);
        headMaterials.add(HEAD_BRONZE);
        headMaterials.add(HEAD_ALUMINUM);
        headMaterials.add(HEAD_NICKEL);
        headMaterials.add(HEAD_LEAD);
        headMaterials.add(HEAD_SILVER);
        headMaterials.add(HEAD_STEEL);
        headMaterials.add(HEAD_ELECTRUM);
        headMaterials.add(HEAD_SOULFORGED_STEEL);
        headMaterials.add(HEAD_DAWNSTONE);
        headMaterials.add(HEAD_CONSTANTAN);
        headMaterials.add(HEAD_COBALT);
        headMaterials.add(HEAD_ARDITE);
        headMaterials.add(HEAD_MANYULLYN);
        headMaterials.add(HEAD_THAUMIUM);
        headMaterials.add(HEAD_VOID);
        for (HeadMaterial mat : headMaterials) {
            if (Config.DISABLED_MATERIALS.contains(mat.getName())) continue;
            System.out.println("Registering " + mat.getName());
            Materials.registerHeadMat(mat);
        }
    }

    private static void initHaftMaterials() {
        Materials.registerHaftMat(HAFT_WOOD);
        Materials.registerHaftMat(HAFT_BONE);
        Materials.registerHaftMat(HAFT_BLAZE_ROD);
        Materials.registerHaftMat(HAFT_END_ROD);
        if (Loader.isModLoaded((String)"betterwithmods")) {
            Materials.registerHaftMat(HAFT_IMPROVED);
        }
        if (Loader.isModLoaded((String)"nex")) {
            Materials.registerHaftMat(HAFT_WITHER_BONE);
        }
        Materials.registerHaftMat(HAFT_TREATED_WOOD);
        Materials.registerHaftMat(HAFT_WITHERED_BONE);
    }

    private static void initHandleMaterials() {
        Materials.registerHandleMat(HANDLE_WOOD);
        Materials.registerHandleMat(HANDLE_BONE);
        Materials.registerHandleMat(HANDLE_CLOTH);
        Materials.registerHandleMat(HANDLE_LEATHER);
        Materials.registerHandleMat(HANDLE_TREATED_WOOD);
        Materials.registerHandleMat(HANDLE_WITHERED_BONE);
    }

    private static void initAdornmentMaterials() {
        Materials.registerAdornmentMat(ADORNMENT_NULL);
        Materials.registerAdornmentMat(ADORNMENT_DIAMOND);
        Materials.registerAdornmentMat(ADORNMENT_EMERALD);
        Materials.registerAdornmentMat(ADORNMENT_QUARTZ);
        Materials.registerAdornmentMat(ADORNMENT_PRISMARINE);
        Materials.registerAdornmentMat(ADORNMENT_ENDER_PEARL);
        Materials.registerAdornmentMat(ADORNMENT_LAPIS);
        Materials.registerAdornmentMat(ADORNMENT_BIOTITE);
        Materials.registerAdornmentMat(ADORNMENT_RUBY);
        Materials.registerAdornmentMat(ADORNMENT_AMETHYST);
        Materials.registerAdornmentMat(ADORNMENT_PERIDOT);
        Materials.registerAdornmentMat(ADORNMENT_TOPAZ);
        Materials.registerAdornmentMat(ADORNMENT_TANZANITE);
        Materials.registerAdornmentMat(ADORNMENT_MALACHITE);
        Materials.registerAdornmentMat(ADORNMENT_SAPPHIRE);
        Materials.registerAdornmentMat(ADORNMENT_AMBER);
        Materials.registerAdornmentMat(ADORNMENT_OBSIDIAN);
        Materials.registerAdornmentMat(ADORNMENT_AQUAMARINE);
    }

    public static void initHeadRepairItems() {
        for (HeadMaterial mat : Materials.head_registry.values()) {
            NonNullList ores;
            if (!mat.getRepairItem().func_190926_b() || !OreDictionary.doesOreNameExist((String)mat.getCraftingItem()) || (ores = OreDictionary.getOres((String)mat.getCraftingItem())).size() <= 0) continue;
            ItemStack repairItem = (ItemStack)OreDictionary.getOres((String)mat.getCraftingItem()).get(0);
            mat.setRepairItem(repairItem);
        }
    }

    static {
        HEAD_WOOD = new HeadMaterial("wood", 0, 59, 2.0f, 0.0f, 15, new ItemStack(Blocks.field_150344_f), "plankWood", "stickWood", Lists.newArrayList((Object[])new String[]{"wood"}), "toolbox");
        HEAD_FLINT = new HeadMaterial("flint", 0, 59, 2.0f, 0.0f, 15, new ItemStack(Items.field_151145_ak), "flint", "gravel", Lists.newArrayList((Object[])new String[]{"wood", "flint"}), "toolbox");
        HEAD_STONE = new HeadMaterial("stone", 1, 131, 4.0f, 1.0f, 5, new ItemStack(Blocks.field_150347_e), "cobblestone", "pebble", Lists.newArrayList((Object[])new String[]{"stone"}), "toolbox");
        HEAD_IRON = new HeadMaterial("iron", 2, 250, 6.0f, 2.0f, 14, new ItemStack(Items.field_151042_j), "ingotIron", "nuggetIron", Lists.newArrayList((Object[])new String[]{"iron"}), "toolbox");
        HEAD_GOLD = new HeadMaterial("gold", 0, 32, 12.0f, 0.0f, 22, new ItemStack(Items.field_151043_k), "ingotGold", "nuggetGold", Lists.newArrayList((Object[])new String[]{"gold"}), "toolbox");
        HEAD_COPPER = new HeadMaterial("copper", 1, 181, 5.4f, 1.5f, 16, ItemStack.field_190927_a, "ingotCopper", "nuggetCopper", Lists.newArrayList((Object[])new String[]{"copper"}), "toolbox");
        HEAD_TIN = new HeadMaterial("tin", 1, 145, 4.9f, 1.0f, 12, ItemStack.field_190927_a, "ingotTin", "nuggetTin", Lists.newArrayList((Object[])new String[]{"tin"}), "toolbox");
        HEAD_BRONZE = new HeadMaterial("bronze", 2, 300, 6.5f, 2.0f, 14, ItemStack.field_190927_a, "ingotBronze", "nuggetBronze", Lists.newArrayList((Object[])new String[]{"bronze"}), "toolbox");
        HEAD_ALUMINUM = new HeadMaterial("aluminum", 1, 161, 5.2f, 1.5f, 14, ItemStack.field_190927_a, "ingotAluminum", "nuggetAluminum", Lists.newArrayList((Object[])new String[]{"aluminum", "aluminium"}), "toolbox");
        HEAD_NICKEL = new HeadMaterial("nickel", 1, 181, 6.4f, 1.5f, 8, ItemStack.field_190927_a, "ingotNickel", "nuggetNickel", Lists.newArrayList((Object[])new String[]{"nickel"}), "toolbox");
        HEAD_LEAD = new HeadMaterial("lead", 2, 168, 6.0f, 2.0f, 4, ItemStack.field_190927_a, "ingotLead", "nuggetLead", Lists.newArrayList((Object[])new String[]{"lead"}), "toolbox");
        HEAD_SILVER = new HeadMaterial("silver", 0, 64, 8.0f, 0.5f, 20, ItemStack.field_190927_a, "ingotSilver", "nuggetSilver", Lists.newArrayList((Object[])new String[]{"silver"}), "toolbox");
        HEAD_STEEL = new HeadMaterial("steel", 2, 500, 7.0f, 2.5f, 14, ItemStack.field_190927_a, "ingotSteel", "nuggetSteel", Lists.newArrayList((Object[])new String[]{"steel"}), "toolbox");
        HEAD_ELECTRUM = new HeadMaterial("electrum", 1, 96, 8.0f, 1.0f, 26, ItemStack.field_190927_a, "ingotElectrum", "nuggetElectrum", Lists.newArrayList((Object[])new String[]{"electrum"}), "toolbox");
        HEAD_SOULFORGED_STEEL = new HeadMaterial("soulforged_steel", 4, 600, 9.0f, 3.0f, 22, ItemStack.field_190927_a, "ingotSoulforgedSteel", "nuggetSoulforgedSteel", Lists.newArrayList((Object[])new String[]{"soulforged_steel"}), "toolbox");
        HEAD_DAWNSTONE = new HeadMaterial("dawnstone", 2, 644, 7.5f, 2.5f, 18, ItemStack.field_190927_a, "ingotDawnstone", "nuggetDawnstone", Lists.newArrayList((Object[])new String[]{"dawnstone"}), "toolbox");
        HEAD_CONSTANTAN = new HeadMaterial("constantan", 2, 215, 6.0f, 2.0f, 14, ItemStack.field_190927_a, "ingotConstantan", "nuggetConstantan", Lists.newArrayList((Object[])new String[]{"constantan"}), "toolbox");
        HEAD_COBALT = new HeadMaterial("cobalt", 3, 825, 12.0f, 2.1f, 16, ItemStack.field_190927_a, "ingotCobalt", "nuggetCobalt", Lists.newArrayList((Object[])new String[]{"cobalt"}), "toolbox");
        HEAD_ARDITE = new HeadMaterial("ardite", 3, 1035, 3.5f, 1.5f, 12, ItemStack.field_190927_a, "ingotArdite", "nuggetArdite", Lists.newArrayList((Object[])new String[]{"ardite"}), "toolbox");
        HEAD_MANYULLYN = new HeadMaterial("manyullyn", 3, 865, 7.0f, 3.0f, 18, ItemStack.field_190927_a, "ingotManyullyn", "nuggetManyullyn", Lists.newArrayList((Object[])new String[]{"manyullyn"}), "toolbox");
        HEAD_THAUMIUM = new HeadMaterial("thaumium", 3, 500, 7.0f, 2.5f, 22, ItemStack.field_190927_a, "ingotThaumium", "nuggetThaumium", Lists.newArrayList((Object[])new String[]{"thaumium"}), "toolbox");
        HEAD_VOID = new HeadMaterial("void", 4, 150, 8.0f, 3.0f, 10, ItemStack.field_190927_a, "ingotVoid", "nuggetVoid", Lists.newArrayList((Object[])new String[]{"void"}), "toolbox");
        HAFT_WOOD = new HaftMaterial("wood", 0, 1.0f, 1.0f, 0.0f, 1.0f, "toolbox");
        HAFT_BONE = new HaftMaterial("bone", 0, 0.8f, 1.0f, 0.5f, 1.3f, "toolbox");
        HAFT_BLAZE_ROD = new HaftMaterial("blaze_rod", 0, 1.125f, 1.0f, 0.5f, 1.2f, "toolbox");
        HAFT_END_ROD = new HaftMaterial("end_rod", 1, 1.5f, 1.25f, 0.0f, 1.2f, "toolbox");
        HAFT_IMPROVED = new HaftMaterial("refined", 0, 1.3f, 1.0f, 0.0f, 0.8f, "toolbox");
        HAFT_WITHER_BONE = new HaftMaterial("wither_bone", 0, 2.0f, 1.0f, 0.0f, 0.8f, "toolbox");
        HAFT_TREATED_WOOD = new HaftMaterial("treated_wood", 0, 1.125f, 1.1f, 0.0f, 0.875f, "toolbox");
        HAFT_WITHERED_BONE = new HaftMaterial("withered_bone", 0, 1.125f, 1.05f, 0.5f, 1.25f, "toolbox");
        HANDLE_WOOD = new HandleMaterial("wood", 1.0f, 1.0f, 1.0f, "toolbox");
        HANDLE_BONE = new HandleMaterial("bone", 0.9375f, 1.1f, 1.3f, "toolbox");
        HANDLE_CLOTH = new HandleMaterial("cloth", 1.125f, 1.0f, 0.8f, "toolbox");
        HANDLE_LEATHER = new HandleMaterial("leather", 1.25f, 1.0f, 0.9f, "toolbox");
        HANDLE_TREATED_WOOD = new HandleMaterial("treated_wood", 1.125f, 1.1f, 0.875f, "toolbox");
        HANDLE_WITHERED_BONE = new HandleMaterial("withered_bone", 1.25f, 1.15f, 1.25f, "toolbox");
        ADORNMENT_NULL = new AdornmentMaterial("null", 0, 1.0f, 1.0f, 0.0f, 1.0f, "toolbox");
        ADORNMENT_DIAMOND = new AdornmentMaterial("diamond", 1, 6.25f, 1.4f, 1.0f, 0.7f, "toolbox");
        ADORNMENT_EMERALD = new AdornmentMaterial("emerald", 1, 5.75f, 1.3f, 1.0f, 0.8f, "toolbox");
        ADORNMENT_QUARTZ = new AdornmentMaterial("quartz", 0, 2.0f, 2.0f, 2.0f, 0.8f, "toolbox");
        ADORNMENT_PRISMARINE = new AdornmentMaterial("prismarine", 0, 2.5f, 1.0f, 1.0f, 1.1f, "toolbox");
        ADORNMENT_ENDER_PEARL = new AdornmentMaterial("ender_pearl", 0, 3.0f, 1.0f, 0.0f, 1.75f, "toolbox");
        ADORNMENT_LAPIS = new AdornmentMaterial("lapis", 0, 1.0f, 1.0f, 0.0f, 2.25f, "toolbox");
        ADORNMENT_BIOTITE = new AdornmentMaterial("biotite", 1, 3.0f, 1.75f, 1.5f, 1.125f, "toolbox");
        ADORNMENT_AMETHYST = new AdornmentMaterial("amethyst", 1, 6.5f, 1.6f, 1.5f, 0.9f, "toolbox");
        ADORNMENT_RUBY = new AdornmentMaterial("ruby", 1, 5.5f, 1.4f, 1.0f, 0.9f, "toolbox");
        ADORNMENT_PERIDOT = new AdornmentMaterial("peridot", 0, 4.5f, 1.5f, 0.5f, 0.75f, "toolbox");
        ADORNMENT_TOPAZ = new AdornmentMaterial("topaz", 0, 4.5f, 1.3f, 1.0f, 0.8f, "toolbox");
        ADORNMENT_TANZANITE = new AdornmentMaterial("tanzanite", 0, 4.25f, 1.2f, 0.5f, 1.1f, "toolbox");
        ADORNMENT_MALACHITE = new AdornmentMaterial("malachite", 0, 4.25f, 1.3f, 0.5f, 0.85f, "toolbox");
        ADORNMENT_SAPPHIRE = new AdornmentMaterial("sapphire", 1, 5.25f, 1.2f, 1.0f, 1.25f, "toolbox");
        ADORNMENT_AMBER = new AdornmentMaterial("amber", 0, 1.75f, 1.2f, 0.5f, 0.75f, "toolbox");
        ADORNMENT_OBSIDIAN = new AdornmentMaterial("obsidian", 1, 7.0f, 1.5f, 1.0f, 1.1f, "toolbox");
        ADORNMENT_AQUAMARINE = new AdornmentMaterial("aquamarine", 0, 1.5f, 1.1f, 0.5f, 0.75f, "toolbox");
        headMaterials = new ArrayList<HeadMaterial>();
    }
}

