/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.recipes;

import api.materials.AdornmentMaterial;
import api.materials.HaftMaterial;
import api.materials.HandleMaterial;
import api.materials.HeadMaterial;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import toolbox.common.CommonProxy;
import toolbox.common.Config;
import toolbox.common.items.ItemSchematic;
import toolbox.common.items.ModItems;
import toolbox.common.materials.ModMaterials;
import toolbox.common.recipes.AxeRecipe;
import toolbox.common.recipes.BookRecipe;
import toolbox.common.recipes.DaggerRecipe;
import toolbox.common.recipes.HammerRecipe;
import toolbox.common.recipes.HandpickRecipe;
import toolbox.common.recipes.HoeRecipe;
import toolbox.common.recipes.MaceRecipe;
import toolbox.common.recipes.PartReplacementRecipe;
import toolbox.common.recipes.PickaxeRecipe;
import toolbox.common.recipes.ShovelRecipe;
import toolbox.common.recipes.SwordRecipe;

public class ModRecipes {
    public static Map<ItemStack, HeadMaterial> head_map = new HashMap<ItemStack, HeadMaterial>();
    public static Map<ItemStack, HaftMaterial> haft_map = new HashMap<ItemStack, HaftMaterial>();
    public static Map<ItemStack, HandleMaterial> handle_map = new HashMap<ItemStack, HandleMaterial>();
    public static Map<ItemStack, AdornmentMaterial> adornment_map = new HashMap<ItemStack, AdornmentMaterial>();

    public static void init() {
        HeadMaterial mat;
        if (!Config.DISABLED_TOOLS.contains("pickaxe")) {
            for (int i : ModItems.pickaxe_head.meta_map.keySet()) {
                mat = ModItems.pickaxe_head.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.pickaxe_head, 1, i), mat.getCraftingItem(), "pickaxe_head", 3).setRegistryName(new ResourceLocation("toolbox", "pickaxe_head_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.pickaxe_head, 1, i), new Object[]{"PPP", "S S", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "pickaxe_head_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("axe")) {
            for (int i : ModItems.axe_head.meta_map.keySet()) {
                mat = ModItems.axe_head.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.axe_head, 1, i), mat.getCraftingItem(), "axe_head", 3).setRegistryName(new ResourceLocation("toolbox", "axe_head_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.axe_head, 1, i), new Object[]{"PPS", "P  ", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "axe_head_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("shovel")) {
            for (int i : ModItems.shovel_head.meta_map.keySet()) {
                mat = ModItems.shovel_head.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.shovel_head, 1, i), mat.getCraftingItem(), "shovel_head", 1).setRegistryName(new ResourceLocation("toolbox", "shovel_head_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.shovel_head, 1, i), new Object[]{"SPS", " S ", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "shovel_head_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("hoe")) {
            for (int i : ModItems.hoe_head.meta_map.keySet()) {
                mat = ModItems.hoe_head.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.hoe_head, 1, i), mat.getCraftingItem(), "hoe_head", 2).setRegistryName(new ResourceLocation("toolbox", "hoe_head_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.hoe_head, 1, i), new Object[]{"PP ", "  S", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "hoe_head_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("handpick")) {
            for (int i : ModItems.handpick_head.meta_map.keySet()) {
                mat = ModItems.handpick_head.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.handpick_head, 1, i), mat.getCraftingItem(), "handpick_head", 2).setRegistryName(new ResourceLocation("toolbox", "handpick_head_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.handpick_head, 1, i), new Object[]{" P ", "S S", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "handpick_head_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("hammer")) {
            for (int i : ModItems.hammer_head.meta_map.keySet()) {
                mat = ModItems.hammer_head.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.hammer_head, 1, i), mat.getCraftingItem(), "hammer_head", 8).setRegistryName(new ResourceLocation("toolbox", "hammer_head_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.hammer_head, 1, i), new Object[]{"PSP", "PPP", "PSP", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "hammer_head_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("sword")) {
            for (int i : ModItems.sword_blade.meta_map.keySet()) {
                mat = ModItems.sword_blade.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.sword_blade, 1, i), mat.getCraftingItem(), "sword_blade", 1).setRegistryName(new ResourceLocation("toolbox", "sword_blade_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.sword_blade, 1, i), new Object[]{" S ", " P ", "SPS", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "sword_blade_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("sword")) {
            for (int i : ModItems.sword_crossguard.meta_map.keySet()) {
                mat = ModItems.sword_crossguard.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.sword_crossguard, 1, i), mat.getCraftingItem(), "sword_crossguard", 1).setRegistryName(new ResourceLocation("toolbox", "crossguard_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.sword_crossguard, 1, i), new Object[]{"SPS", "   ", " S ", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "crossguard_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("dagger")) {
            for (int i : ModItems.dagger_blade.meta_map.keySet()) {
                mat = ModItems.dagger_blade.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.dagger_blade, 1, i), mat.getCraftingItem(), "dagger_blade", 1).setRegistryName(new ResourceLocation("toolbox", "dagger_blade_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.dagger_blade, 1, i), new Object[]{" S ", " P ", "S S", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "dagger_blade_" + mat.getName())));
            }
        }
        if (!Config.DISABLED_TOOLS.contains("mace")) {
            for (int i : ModItems.mace_head.meta_map.keySet()) {
                mat = ModItems.mace_head.meta_map.get(i);
                if (Config.DISABLE_TOOL_HEAD_RECIPES && CommonProxy.smelteryMaterials.contains(mat)) continue;
                if (Config.ENABLE_SCHEMATICS) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ModRecipes.getToolHeadSchematicRecipe(new ItemStack((Item)ModItems.mace_head, 1, i), mat.getCraftingItem(), "mace_head", 4).setRegistryName(new ResourceLocation("toolbox", "mace_head_" + mat.getName())));
                    continue;
                }
                ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)ModItems.mace_head, 1, i), new Object[]{"SPS", "PPP", "SPS", Character.valueOf('P'), mat.getCraftingItem(), Character.valueOf('S'), mat.getSmallCraftingItem()}).setRegistryName(new ResourceLocation("toolbox", "mace_head_" + mat.getName())));
            }
        }
        ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(null, new ItemStack((Item)ModItems.handle, 1, 0), new Object[]{"stickWood", new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation("toolbox", "handle_0")));
        ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(null, new ItemStack((Item)ModItems.handle, 1, 1), new Object[]{"stickWood", new ItemStack(Items.field_151116_aA)}).setRegistryName(new ResourceLocation("toolbox", "handle_1")));
        OreDictionary.registerOre((String)"pebble", (ItemStack)new ItemStack((Item)ModItems.rock));
        ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(null, new ItemStack((Item)ModItems.rock, 9), new Object[]{"cobblestone"}).setRegistryName(new ResourceLocation("toolbox", "pebble")));
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack(Blocks.field_150347_e), new Object[]{"RRR", "RRR", "RRR", Character.valueOf('R'), new ItemStack((Item)ModItems.rock)}).setRegistryName(new ResourceLocation("toolbox", "cobble")));
        RecipeSorter.register((String)"toolbox:book", BookRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        ForgeRegistries.RECIPES.register(new BookRecipe().setRegistryName(new ResourceLocation("toolbox", "book")));
        if (Config.ALLOW_ADORNMENT_REPLACEMENT) {
            ForgeRegistries.RECIPES.register(new PartReplacementRecipe().setRegistryName(new ResourceLocation("toolbox", "part_replacement")));
        }
        ModRecipes.initToolRecipes();
        ModRecipes.initMaterialItems();
        ModRecipes.registerSchematicRecipe("pickaxe", "pickaxe_head", "PPP", " S ", " S ");
        ModRecipes.registerSchematicRecipe("axe", "axe_head", "PP", "PS", " S");
        ModRecipes.registerSchematicRecipe("shovel", "shovel_head", "P", "S", "S");
        ModRecipes.registerSchematicRecipe("hoe", "hoe_head", "PP", " S", " S");
        ModRecipes.registerSchematicRecipe("handpick", "handpick_head", "PP", " S");
        ModRecipes.registerSchematicRecipe("hammer", "hammer_head", "PPP", "PSP", " S ");
        ModRecipes.registerSchematicRecipe("climbing_pick", "climbing_pick_head", "PP ", " SP", " S ");
        ModRecipes.registerSchematicRecipe("sword", "sword_blade", "P", "P", "S");
        ModRecipes.registerSchematicRecipe("sword", "sword_crossguard", "PSP", " S ", " P ");
        ModRecipes.registerSchematicRecipe("dagger", "dagger_blade", "P", "S");
        ModRecipes.registerSchematicRecipe("mace", "mace_head", "PP", "PP", " S");
    }

    private static void registerSchematicRecipe(String toolType, String schematicType, String row1, String row2, String row3) {
        if (Config.ENABLE_SCHEMATICS && !Config.DISABLED_TOOLS.contains(toolType) && Config.CRAFTED_SCHEMATICS.contains(schematicType) && ItemSchematic.subtypes.contains(schematicType)) {
            ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, ModItems.schematic.createStack(schematicType), new Object[]{row1, row2, row3, Character.valueOf('P'), new ItemStack(Items.field_151121_aF), Character.valueOf('S'), new ItemStack(Items.field_151055_y)}).setRegistryName(schematicType + "_schematic"));
        }
    }

    private static void registerSchematicRecipe(String toolType, String schematicType, String row1, String row2) {
        if (Config.ENABLE_SCHEMATICS && !Config.DISABLED_TOOLS.contains(toolType) && Config.CRAFTED_SCHEMATICS.contains(schematicType) && ItemSchematic.subtypes.contains(schematicType)) {
            ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, ModItems.schematic.createStack(schematicType), new Object[]{row1, row2, Character.valueOf('P'), new ItemStack(Items.field_151121_aF), Character.valueOf('S'), new ItemStack(Items.field_151055_y)}).setRegistryName(schematicType + "_schematic"));
        }
    }

    public static void initToolRecipes() {
        if (!Config.DISABLED_TOOLS.contains("pickaxe")) {
            RecipeSorter.register((String)"toolbox:pickaxe", PickaxeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new PickaxeRecipe().setRegistryName(new ResourceLocation("toolbox", "pickaxe")));
        }
        if (!Config.DISABLED_TOOLS.contains("axe")) {
            RecipeSorter.register((String)"toolbox:axe", AxeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new AxeRecipe().setRegistryName(new ResourceLocation("toolbox", "axe")));
        }
        if (!Config.DISABLED_TOOLS.contains("shovel")) {
            RecipeSorter.register((String)"toolbox:shovel", ShovelRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new ShovelRecipe().setRegistryName(new ResourceLocation("toolbox", "shovel")));
        }
        if (!Config.DISABLED_TOOLS.contains("hoe")) {
            RecipeSorter.register((String)"toolbox:hoe", HoeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new HoeRecipe().setRegistryName(new ResourceLocation("toolbox", "hoe")));
        }
        if (!Config.DISABLED_TOOLS.contains("handpick")) {
            RecipeSorter.register((String)"toolbox:handpick", HandpickRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new HandpickRecipe().setRegistryName(new ResourceLocation("toolbox", "handpick")));
        }
        if (!Config.DISABLED_TOOLS.contains("hammer")) {
            RecipeSorter.register((String)"toolbox:hammer", HammerRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new HammerRecipe().setRegistryName(new ResourceLocation("toolbox", "hammer")));
        }
        if (!Config.DISABLED_TOOLS.contains("sword")) {
            RecipeSorter.register((String)"toolbox:sword", SwordRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new SwordRecipe().setRegistryName(new ResourceLocation("toolbox", "sword")));
        }
        if (!Config.DISABLED_TOOLS.contains("dagger")) {
            RecipeSorter.register((String)"toolbox:dagger", DaggerRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new DaggerRecipe().setRegistryName(new ResourceLocation("toolbox", "dagger")));
        }
        if (!Config.DISABLED_TOOLS.contains("mace")) {
            RecipeSorter.register((String)"toolbox:mace", MaceRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            ForgeRegistries.RECIPES.register(new MaceRecipe().setRegistryName(new ResourceLocation("toolbox", "mace")));
        }
    }

    public static void initMaterialItems() {
        haft_map.put(new ItemStack(Items.field_151055_y), ModMaterials.HAFT_WOOD);
        haft_map.put(new ItemStack(Items.field_151103_aS), ModMaterials.HAFT_BONE);
        haft_map.put(new ItemStack(Items.field_151072_bj), ModMaterials.HAFT_BLAZE_ROD);
        haft_map.put(new ItemStack(Blocks.field_185764_cQ), ModMaterials.HAFT_END_ROD);
        Item haft = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("betterwithmods:material"));
        Item witherBone = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("nex:item_bone_wither"));
        if (haft != null) {
            haft_map.put(new ItemStack(haft, 1, 36), ModMaterials.HAFT_IMPROVED);
        }
        if (witherBone != null) {
            haft_map.put(new ItemStack(witherBone, 1, 0), ModMaterials.HAFT_WITHER_BONE);
        }
        for (ItemStack treatedStick : OreDictionary.getOres((String)"stickTreatedWood")) {
            haft_map.put(treatedStick, ModMaterials.HAFT_TREATED_WOOD);
        }
        for (ItemStack witheredBone : OreDictionary.getOres((String)"boneWithered")) {
            haft_map.put(witheredBone, ModMaterials.HAFT_WITHERED_BONE);
        }
        for (ItemStack witheredBone : OreDictionary.getOres((String)"boneWither")) {
            if (witheredBone.func_77973_b().getRegistryName().func_110624_b().equals("nex")) continue;
            haft_map.put(witheredBone, ModMaterials.HAFT_WITHERED_BONE);
        }
        handle_map.put(new ItemStack((Item)ModItems.handle, 1, 0), ModMaterials.HANDLE_CLOTH);
        handle_map.put(new ItemStack((Item)ModItems.handle, 1, 1), ModMaterials.HANDLE_LEATHER);
        handle_map.put(new ItemStack(Items.field_151055_y, 1, 0), ModMaterials.HANDLE_WOOD);
        handle_map.put(new ItemStack(Items.field_151103_aS, 1, 0), ModMaterials.HANDLE_BONE);
        for (ItemStack treatedStick : OreDictionary.getOres((String)"stickTreatedWood")) {
            handle_map.put(treatedStick, ModMaterials.HANDLE_TREATED_WOOD);
        }
        for (ItemStack witheredBone : OreDictionary.getOres((String)"boneWithered")) {
            handle_map.put(witheredBone, ModMaterials.HANDLE_WITHERED_BONE);
        }
        for (ItemStack witheredBone : OreDictionary.getOres((String)"boneWither")) {
            if (witheredBone.func_77973_b().getRegistryName().func_110624_b().equals("nex")) continue;
            handle_map.put(witheredBone, ModMaterials.HANDLE_WITHERED_BONE);
        }
        adornment_map.put(new ItemStack(Items.field_151045_i), ModMaterials.ADORNMENT_DIAMOND);
        adornment_map.put(new ItemStack(Items.field_151166_bC), ModMaterials.ADORNMENT_EMERALD);
        adornment_map.put(new ItemStack(Items.field_151128_bU), ModMaterials.ADORNMENT_QUARTZ);
        adornment_map.put(new ItemStack(Items.field_179563_cD), ModMaterials.ADORNMENT_PRISMARINE);
        adornment_map.put(new ItemStack(Items.field_151079_bi), ModMaterials.ADORNMENT_ENDER_PEARL);
        adornment_map.put(new ItemStack(Items.field_151100_aR, 1, 4), ModMaterials.ADORNMENT_LAPIS);
        for (ItemStack biotite : OreDictionary.getOres((String)"gemEnderBiotite")) {
            adornment_map.put(biotite, ModMaterials.ADORNMENT_BIOTITE);
        }
        for (ItemStack ruby : OreDictionary.getOres((String)"gemRuby")) {
            adornment_map.put(ruby, ModMaterials.ADORNMENT_RUBY);
        }
        for (ItemStack amethyst : OreDictionary.getOres((String)"gemAmethyst")) {
            adornment_map.put(amethyst, ModMaterials.ADORNMENT_AMETHYST);
        }
        for (ItemStack peridot : OreDictionary.getOres((String)"gemPeridot")) {
            adornment_map.put(peridot, ModMaterials.ADORNMENT_PERIDOT);
        }
        for (ItemStack topaz : OreDictionary.getOres((String)"gemTopaz")) {
            adornment_map.put(topaz, ModMaterials.ADORNMENT_TOPAZ);
        }
        for (ItemStack tanzanite : OreDictionary.getOres((String)"gemTanzanite")) {
            adornment_map.put(tanzanite, ModMaterials.ADORNMENT_TANZANITE);
        }
        for (ItemStack malachite : OreDictionary.getOres((String)"gemMalachite")) {
            adornment_map.put(malachite, ModMaterials.ADORNMENT_MALACHITE);
        }
        for (ItemStack sapphire : OreDictionary.getOres((String)"gemSapphire")) {
            adornment_map.put(sapphire, ModMaterials.ADORNMENT_SAPPHIRE);
        }
        for (ItemStack amber : OreDictionary.getOres((String)"gemAmber")) {
            adornment_map.put(amber, ModMaterials.ADORNMENT_AMBER);
        }
        for (ItemStack obsidian : OreDictionary.getOres((String)"gemObsidian")) {
            adornment_map.put(obsidian, ModMaterials.ADORNMENT_OBSIDIAN);
        }
        for (ItemStack aquamarine : OreDictionary.getOres((String)"gemAquamarine")) {
            adornment_map.put(aquamarine, ModMaterials.ADORNMENT_AQUAMARINE);
        }
    }

    private static IRecipe getToolHeadSchematicRecipe(ItemStack output, String material, String type, int cost) {
        NonNullList inputs = NonNullList.func_191197_a((int)(cost + 1), (Object)Ingredient.field_193370_a);
        ItemStack schematic = new ItemStack((Item)ModItems.schematic);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Type", type);
        schematic.func_77982_d(nbt);
        IngredientNBT schematicIngredient = new IngredientNBT(schematic){};
        inputs.set(0, (Object)schematicIngredient);
        for (int i = 1; i <= cost; ++i) {
            inputs.set(i, (Object)new OreIngredient(material));
        }
        return new ShapelessOreRecipe(null, inputs, output);
    }
}

