/*
 * Decompiled with CFR 0.152.
 */
package toolbox.compat.tconstruct;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toolbox.common.Config;
import toolbox.common.items.ItemBase;
import toolbox.common.items.ModItems;
import toolbox.common.items.parts.ItemToolHead;

public class ItemCast
extends ItemBase {
    private static final int ingotCost = 144;
    private static final int nuggetCost = 16;

    public ItemCast() {
        super("cast");
        this.func_77627_a(true);
    }

    public static ItemStack getStack(EnumType type, int count) {
        return new ItemStack((Item)ModItems.cast, count, type.getMetadata());
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + EnumType.VALUES[stack.func_77960_j()].getName();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (EnumType type : EnumType.values()) {
                if (Config.DISABLED_TOOLS.contains(type.getTool())) continue;
                items.add((Object)ItemCast.getStack(type, 1));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (EnumType type : EnumType.VALUES) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)type.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString() + "_" + type.getName(), "inventory"));
        }
    }

    public static enum EnumType {
        PICKAXE_HEAD(ModItems.pickaxe_head, "pickaxe", 432),
        AXE_HEAD(ModItems.axe_head, "axe", 432),
        SHOVEL_HEAD(ModItems.shovel_head, "shovel", 144),
        HOE_HEAD(ModItems.hoe_head, "hoe", 288),
        HANDPICK_HEAD(ModItems.handpick_head, "handpick", 144),
        HAMMER_HEAD(ModItems.hammer_head, "hammer", 1008),
        SWORD_BLADE(ModItems.sword_blade, "sword", 288),
        SWORD_CROSSGUARD(ModItems.sword_crossguard, "sword", 432),
        DAGGER_BLADE(ModItems.dagger_blade, "dagger", 144),
        MACE_HEAD(ModItems.mace_head, "mace", 720);

        public static final EnumType[] VALUES;
        private final ItemToolHead item;
        private final String tool;
        private final int cost;

        private EnumType(ItemToolHead item, String tool, int cost) {
            this.item = item;
            this.tool = tool;
            this.cost = cost;
        }

        int getMetadata() {
            return this.ordinal();
        }

        String getName() {
            return this.name().toLowerCase();
        }

        public ItemToolHead getItem() {
            return this.item;
        }

        public String getTool() {
            return this.tool;
        }

        public int getCost() {
            return this.cost;
        }

        static {
            VALUES = EnumType.values();
        }
    }
}

