/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.util;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.util.Log;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NonnullType;
import info.loenwind.autosave.util.NullHelper;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public abstract class HandleGenericType<T>
implements IHandler<T> {
    @Nonnull
    protected final Class<? extends T> clazz;
    protected final @NonnullType Type[] types;
    protected final List<IHandler>[] subHandlers;

    protected HandleGenericType(Class<? extends T> clazz) {
        this.clazz = clazz;
        this.types = new Type[this.getRequiredParameters()];
        this.subHandlers = new List[this.getRequiredParameters()];
    }

    protected HandleGenericType(Class<? extends T> clazz, Registry registry, Type ... parameterTypes) throws NoHandlerFoundException {
        this(clazz);
        if (parameterTypes.length != this.getRequiredParameters()) {
            throw new IllegalArgumentException("Mismatch of parameter count. Required: " + this.getRequiredParameters() + "  Found: " + parameterTypes.length);
        }
        for (int i = 0; i < this.getRequiredParameters(); ++i) {
            Type type;
            this.types[i] = type = parameterTypes[i];
            if (type == null) {
                throw new IllegalArgumentException("Null type passed to HandleGenericType()");
            }
            try {
                List<IHandler> handlers = registry.findHandlers(type);
                if (handlers.isEmpty()) {
                    throw new NoHandlerFoundException(type, "Unknown");
                }
                this.subHandlers[i] = handlers;
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new NoHandlerFoundException(type, "Unknown", e);
            }
        }
    }

    @Override
    public final Class<?> getRootType() {
        return this.clazz;
    }

    @Nullable
    protected abstract IHandler<? extends T> create(Registry var1, Type ... var2) throws NoHandlerFoundException;

    protected int getRequiredParameters() {
        return this.getRootType().getTypeParameters().length;
    }

    protected boolean canHandle(Type type) {
        return TypeUtil.isAssignable(this.getRootType(), type);
    }

    @Override
    @Nullable
    public IHandler<? extends T> getHandler(Registry registry, Type type) {
        if (!this.canHandle(type)) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            try {
                return this.create(registry, NullHelper.notnullJ(((ParameterizedType)type).getActualTypeArguments(), "ParameterizedType#getActualTypeArguments"));
            }
            catch (NoHandlerFoundException e) {
                Log.LOGGER.error((Object)e);
            }
        }
        return null;
    }

    protected final void storeRecursive(int param, Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, String name, Object object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        for (IHandler handler : this.subHandlers[param]) {
            if (!handler.store(registry, phase, nbt, this.types[param], name, object)) continue;
            return;
        }
    }

    @Nullable
    protected final <V> V readRecursive(int param, Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, String name, @Nullable V object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        for (IHandler handler : this.subHandlers[param]) {
            V result = handler.read(registry, phase, nbt, this.types[param], name, object);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

