/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.utility;

import java.util.Random;
import java.util.UUID;

public class RandomHelper {
    private static final Random RANDOM = new Random();

    public static int getNumberInRange(int min, int max) {
        return RandomHelper.getNumberInRange(min, max, RANDOM);
    }

    public static int getNumberInRange(int min, int max, Random random) {
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return random.nextInt(max - min + 1) + min;
    }

    public static <E extends Enum> E getEnum(Class<? extends E> cls) {
        return RandomHelper.getEnum(cls, RANDOM);
    }

    public static <E extends Enum> E getEnum(Class<? extends E> cls, Random random) {
        return (E)((Enum[])cls.getEnumConstants())[random.nextInt(((Enum[])cls.getEnumConstants()).length)];
    }

    public static UUID getUUID() {
        return RandomHelper.getUUID(RANDOM);
    }

    public static UUID getUUID(Random random) {
        long mostSignificantBits = random.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long leastSignificantBits = random.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public static Random getRandom() {
        return RANDOM;
    }
}

