/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.biome.data;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.json.JsonFormat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import logictechcorp.libraryex.utility.FileHelper;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BiomeDataManager {
    protected final Map<ResourceLocation, BiomeData> defaultBiomeData = new HashMap<ResourceLocation, BiomeData>();
    protected final Map<ResourceLocation, BiomeData> currentBiomeData = new HashMap<ResourceLocation, BiomeData>();
    protected final Map<ResourceLocation, BiomeManager.BiomeEntry> currentBiomeEntries = new ConcurrentHashMap<ResourceLocation, BiomeManager.BiomeEntry>();
    protected final Logger logger;

    public BiomeDataManager(String loggerName) {
        this.logger = LogManager.getLogger((String)loggerName);
    }

    public void setup() {
        this.defaultBiomeData.putAll(this.currentBiomeData);
        this.currentBiomeData.clear();
        this.currentBiomeEntries.clear();
    }

    public void registerBiomeData(BiomeData biomeData) {
        if (biomeData != null && biomeData.getBiome() != null && biomeData != BiomeData.EMPTY) {
            Biome biome = biomeData.getBiome();
            ResourceLocation biomeRegistryName = biome.getRegistryName();
            this.currentBiomeData.put(biomeRegistryName, biomeData);
            if (!biomeData.isSubBiome()) {
                if (biomeData.isEnabled()) {
                    this.currentBiomeEntries.put(biomeRegistryName, new BiomeManager.BiomeEntry(biome, biomeData.getGenerationWeight()));
                } else {
                    this.currentBiomeEntries.remove(biomeRegistryName);
                }
            }
        }
    }

    public void unregisterBiomeData(Biome biome) {
        if (biome != null) {
            ResourceLocation biomeRegistryName = biome.getRegistryName();
            this.currentBiomeData.remove(biomeRegistryName);
            this.currentBiomeEntries.remove(biomeRegistryName);
        }
    }

    public abstract void onWorldLoad(WorldEvent.Load var1);

    public abstract void onWorldUnload(WorldEvent.Unload var1);

    public void readBiomeDataConfigs(Path biomeConfigDirectoryPath) {
        if (Files.exists(biomeConfigDirectoryPath, new LinkOption[0])) {
            this.logger.info("Reading biome configs.");
            try {
                Iterator pathIter = Files.walk(biomeConfigDirectoryPath, new FileVisitOption[0]).iterator();
                while (pathIter.hasNext()) {
                    Path configPath = (Path)pathIter.next();
                    File configFile = configPath.toFile();
                    if (FileHelper.getFileExtension(configFile).equals("json")) {
                        if (Files.isReadable(configPath)) {
                            String fileText = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset()).trim();
                            if (fileText.startsWith("{") && fileText.endsWith("}")) {
                                FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                                config.load();
                                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation((String)config.get("biome")));
                                if (biome != null) {
                                    BiomeData biomeData = this.hasBiomeData(biome) ? this.getBiomeData(biome) : this.createBiomeData(biome.getRegistryName(), 10, true, false);
                                    biomeData.readFromConfig(this, (Config)config);
                                    this.registerBiomeData(biomeData);
                                }
                                config.save();
                                config.close();
                                continue;
                            }
                            this.logger.warn("Skipping biome config at {}. Its contents are invalid.", (Object)configPath);
                            continue;
                        }
                        this.logger.warn("Skipping biome config at {}. It is unreadable.", (Object)configPath);
                        continue;
                    }
                    if (configFile.isDirectory()) continue;
                    this.logger.warn("Skipping biome config at {}. It is not a json file.", (Object)configPath);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void createBiomeDataConfigs(Path biomeConfigDirectoryPath) {
        if (Files.notExists(biomeConfigDirectoryPath, new LinkOption[0])) {
            this.logger.info("Creating biome configs.");
            try {
                for (BiomeData biomeData : this.defaultBiomeData.values()) {
                    String biomeRegistryName = biomeData.getBiome().getRegistryName().toString();
                    File configFile = new File(biomeConfigDirectoryPath.toFile(), biomeRegistryName.replace(":", "/") + ".json");
                    Files.createDirectories(configFile.getParentFile().toPath(), new FileAttribute[0]);
                    FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                    biomeData.writeToConfig((Config)config);
                    config.save();
                    config.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public BiomeData createBiomeData(ResourceLocation biomeRegistryName, int generationWeight, boolean useDefaultDecorations, boolean isSubBiome) {
        return new BiomeData(biomeRegistryName, generationWeight, useDefaultDecorations, isSubBiome);
    }

    public boolean hasBiomeData(Biome biome) {
        return this.currentBiomeData.containsKey(biome.getRegistryName());
    }

    public BiomeData getBiomeData(Biome biome) {
        return this.currentBiomeData.getOrDefault(biome.getRegistryName(), BiomeData.EMPTY);
    }

    public Map<ResourceLocation, BiomeData> getDefaultBiomeData() {
        return Collections.unmodifiableMap(this.defaultBiomeData);
    }

    public Map<ResourceLocation, BiomeData> getCurrentBiomeData() {
        return Collections.unmodifiableMap(this.currentBiomeData);
    }

    public Map<ResourceLocation, BiomeManager.BiomeEntry> getCurrentBiomeEntries() {
        return Collections.unmodifiableMap(this.currentBiomeEntries);
    }
}

