/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorListener;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface ICraftingManager {
    public Collection<ICraftingTask> getTasks();

    @Nullable
    public ICraftingTask getTask(UUID var1);

    public Map<String, List<IItemHandlerModifiable>> getNamedContainers();

    public void add(@Nonnull ICraftingTask var1);

    public void cancel(@Nullable UUID var1);

    @Nullable
    public ICraftingTask create(ItemStack var1, long var2);

    @Nullable
    public ICraftingTask create(FluidStack var1, long var2);

    @Nullable
    @Deprecated
    default public ICraftingTask request(ItemStack stack, int amount) {
        return this.request(null, stack, (long)amount);
    }

    @Nullable
    @Deprecated
    default public ICraftingTask request(FluidStack stack, int amount) {
        return this.request(null, stack, (long)amount);
    }

    @Nullable
    public ICraftingTask request(Object var1, ItemStack var2, long var3);

    @Nullable
    public ICraftingTask request(Object var1, FluidStack var2, long var3);

    public void track(ItemStack var1);

    public void track(FluidStack var1);

    public Set<ICraftingPattern> getPatterns();

    public void rebuild();

    public ICraftingPattern getPattern(ItemStack var1, int var2, Predicate<ICraftingPattern> var3);

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern, int flags) {
        return this.getPattern(pattern, flags, p -> true);
    }

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern) {
        return this.getPattern(pattern, 3);
    }

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern, Predicate<ICraftingPattern> filter) {
        return this.getPattern(pattern, 3, filter);
    }

    public ICraftingPattern getPattern(FluidStack var1, Predicate<ICraftingPattern> var2);

    @Nullable
    default public ICraftingPattern getPattern(FluidStack pattern) {
        return this.getPattern(pattern, (ICraftingPattern p) -> true);
    }

    public void update();

    public void readFromNbt(NBTTagCompound var1);

    public NBTTagCompound writeToNbt(NBTTagCompound var1);

    public void addListener(ICraftingMonitorListener var1);

    public void removeListener(ICraftingMonitorListener var1);

    public void onTaskChanged();

    public Set<ICraftingPatternContainer> getAllContainer(ICraftingPattern var1);
}

