/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.network;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.energy.IEnergy;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraph;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterManager;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityManager;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.tracker.IStorageTracker;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public interface INetwork {
    public int getEnergyUsage();

    public BlockPos getPosition();

    public boolean canRun();

    public INetworkNodeGraph getNodeGraph();

    public ISecurityManager getSecurityManager();

    public ICraftingManager getCraftingManager();

    public IEnergy getEnergy();

    public IItemGridHandler getItemGridHandler();

    public IFluidGridHandler getFluidGridHandler();

    public INetworkItemHandler getNetworkItemHandler();

    public IStorageCache<ItemStack> getItemStorageCache();

    public IStorageCache<FluidStack> getFluidStorageCache();

    public IReaderWriterManager getReaderWriterManager();

    @Nullable
    @Deprecated
    default public ItemStack insertItem(@Nonnull ItemStack stack, int size, Action action) {
        StackListResult<ItemStack> result = this.insertItem(stack, (long)size, action);
        if (result == null) {
            return null;
        }
        return result.getFixedStack();
    }

    @Nullable
    public StackListResult<ItemStack> insertItem(@Nonnull ItemStack var1, long var2, Action var4);

    @Nullable
    default public ItemStack insertItemTracked(@Nonnull ItemStack stack, int size) {
        ItemStack stackCopy = stack.func_77946_l();
        stackCopy.func_190920_e(size);
        this.getCraftingManager().track(stackCopy);
        if (stackCopy.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return this.insertItem(stack, size, Action.PERFORM);
    }

    @Nonnull
    @Deprecated
    default public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, Action action, Predicate<IStorage<ItemStack>> filter) {
        StackListResult<ItemStack> result = this.extractItem(stack, (long)size, flags, action, filter);
        if (result == null) {
            return ItemStack.field_190927_a;
        }
        return result.getFixedStack();
    }

    @Nonnull
    @Deprecated
    default public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, Action action) {
        return this.extractItem(stack, size, flags, action, (IStorage<ItemStack> s) -> true);
    }

    @Nonnull
    @Deprecated
    default public ItemStack extractItem(@Nonnull ItemStack stack, int size, Action action) {
        return this.extractItem(stack, size, 3, action);
    }

    @Nullable
    public StackListResult<ItemStack> extractItem(@Nonnull ItemStack var1, long var2, int var4, Action var5, Predicate<IStorage<ItemStack>> var6);

    @Nullable
    default public StackListResult<ItemStack> extractItem(@Nonnull ItemStack stack, long size, int flags, Action action) {
        return this.extractItem(stack, size, flags, action, (IStorage<ItemStack> s) -> true);
    }

    @Nullable
    default public StackListResult<ItemStack> extractItem(@Nonnull ItemStack stack, long size, Action action) {
        return this.extractItem(stack, size, 3, action);
    }

    @Nullable
    @Deprecated
    default public FluidStack insertFluid(@Nonnull FluidStack stack, int size, Action action) {
        StackListResult<FluidStack> result = this.insertFluid(stack, (long)size, action);
        if (result == null) {
            return null;
        }
        return result.getFixedStack();
    }

    @Nullable
    public StackListResult<FluidStack> insertFluid(@Nonnull FluidStack var1, long var2, Action var4);

    @Nullable
    default public FluidStack insertFluidTracked(@Nonnull FluidStack stack, int size) {
        FluidStack stackCopy = stack.copy();
        stackCopy.amount = size;
        this.getCraftingManager().track(stackCopy);
        if (stackCopy.amount < 1) {
            return null;
        }
        return this.insertFluid(stack, size, Action.PERFORM);
    }

    @Nullable
    @Deprecated
    default public FluidStack extractFluid(@Nonnull FluidStack stack, int size, int flags, Action action, Predicate<IStorage<FluidStack>> filter) {
        StackListResult<FluidStack> result = this.extractFluid(stack, (long)size, flags, action, filter);
        if (result == null) {
            return null;
        }
        return result.getFixedStack();
    }

    @Nullable
    @Deprecated
    default public FluidStack extractFluid(FluidStack stack, int size, int flags, Action action) {
        return this.extractFluid(stack, size, flags, action, (IStorage<FluidStack> s) -> true);
    }

    @Nullable
    @Deprecated
    default public FluidStack extractFluid(FluidStack stack, int size, Action action) {
        return this.extractFluid(stack, size, 2, action);
    }

    @Nullable
    public StackListResult<FluidStack> extractFluid(@Nonnull FluidStack var1, long var2, int var4, Action var5, Predicate<IStorage<FluidStack>> var6);

    @Nullable
    default public StackListResult<FluidStack> extractFluid(FluidStack stack, long size, int flags, Action action) {
        return this.extractFluid(stack, size, flags, action, (IStorage<FluidStack> s) -> true);
    }

    @Nullable
    default public StackListResult<FluidStack> extractFluid(FluidStack stack, long size, Action action) {
        return this.extractFluid(stack, size, 2, action);
    }

    public IStorageTracker<ItemStack> getItemStorageTracker();

    public IStorageTracker<FluidStack> getFluidStorageTracker();

    public World world();
}

