/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.storage;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import java.util.Collection;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IStorage<T> {
    public static final Comparator<IStorage<?>> COMPARATOR = (left, right) -> {
        int compare = Integer.compare(right.getPriority(), left.getPriority());
        return compare != 0 ? compare : Long.compare(right.getStored(), left.getStored());
    };

    public Collection<StackListEntry<T>> getEntries();

    @Nullable
    public StackListResult<T> insert(@Nonnull T var1, long var2, Action var4);

    @Nullable
    public StackListResult<T> extract(@Nonnull T var1, long var2, int var4, Action var5);

    public long getStored();

    public int getPriority();

    public AccessType getAccessType();

    public long getCacheDelta(long var1, long var3, long var5);
}

