/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.util;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class StackListResult<T> {
    @Nonnull
    private final T stack;
    @Nullable
    private UUID id;
    private long change;

    public StackListResult(@Nonnull T stack, long change) {
        this.stack = stack;
        this.change = change;
    }

    public StackListResult(@Nonnull T stack, @Nonnull UUID id, long change) {
        this.stack = stack;
        this.id = id;
        this.change = change;
    }

    public static ItemStack nullToEmpty(@Nullable StackListResult<ItemStack> stackListResult) {
        return stackListResult == null ? ItemStack.field_190927_a : stackListResult.getFixedStack();
    }

    public void grow(long count) {
        this.change += count;
    }

    public void shrink(long count) {
        this.change -= count;
    }

    public void setCount(long count) {
        this.change = count;
    }

    public T getFixedStack() {
        int stackSize;
        int n = stackSize = this.getCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.getCount();
        if (this.stack instanceof ItemStack) {
            ((ItemStack)this.stack).func_190920_e(stackSize);
        } else if (this.stack instanceof FluidStack) {
            ((FluidStack)this.stack).amount = stackSize;
        }
        return this.stack;
    }

    @Nonnull
    public T getStack() {
        return this.stack;
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public long getChange() {
        return this.change;
    }

    public long getCount() {
        return Math.abs(this.change);
    }
}

