/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementComparable;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingMonitorElementFluidRender
implements ICraftingMonitorElement,
ICraftingMonitorElementComparable {
    private static final int COLOR_PROCESSING = -2494985;
    private static final int COLOR_SCHEDULED = -1514038;
    private static final int COLOR_CRAFTING = -5383226;
    public static final String ID = "fluid_render";
    private final FluidStack stack;
    private long stored;
    private long processing;
    private long scheduled;
    private long crafting;

    public CraftingMonitorElementFluidRender(FluidStack stack, long stored, long processing, long scheduled, long crafting) {
        this.stack = stack;
        this.stored = stored;
        this.processing = processing;
        this.scheduled = scheduled;
        this.crafting = crafting;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers) {
        if (this.processing > 0L) {
            drawers.getOverlayDrawer().draw(x, y, -2494985);
        } else if (this.scheduled > 0L) {
            drawers.getOverlayDrawer().draw(x, y, -1514038);
        } else if (this.crafting > 0L) {
            drawers.getOverlayDrawer().draw(x, y, -5383226);
        }
        drawers.getFluidDrawer().draw(x + 4, y + 6, this.stack);
        float scale = drawers.getFontRenderer().func_82883_a() ? 1.0f : 0.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int yy = y + 7;
        if (this.stored > 0L) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.stored)}));
            yy += 7;
        }
        if (this.processing > 0L) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.processing", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.processing)}));
            yy += 7;
        }
        if (this.scheduled > 0L) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.scheduled", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.scheduled)}));
            yy += 7;
        }
        if (this.crafting > 0L && this.scheduled < 1L) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy, scale), I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.crafting", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.crafting)}));
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getBaseId() {
        return ID;
    }

    @Override
    @Nullable
    public String getTooltip() {
        return this.stack.getLocalizedName();
    }

    @Override
    public long getStored() {
        return this.stored;
    }

    @Override
    public long getProcessing() {
        return this.processing;
    }

    @Override
    public long getScheduled() {
        return this.scheduled;
    }

    @Override
    public long getCrafting() {
        return this.crafting;
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stack.writeToNBT(new NBTTagCompound()));
        buf.writeLong(this.stored);
        buf.writeLong(this.processing);
        buf.writeLong(this.scheduled);
        buf.writeLong(this.crafting);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        if (element.getId().equals(this.getId()) && this.elementHashCode() == element.elementHashCode()) {
            this.stored += ((CraftingMonitorElementFluidRender)element).stored;
            this.processing += ((CraftingMonitorElementFluidRender)element).processing;
            this.scheduled += ((CraftingMonitorElementFluidRender)element).scheduled;
            this.crafting += ((CraftingMonitorElementFluidRender)element).crafting;
            return true;
        }
        return false;
    }

    @Override
    public int elementHashCode() {
        return API.instance().getFluidStackHashCode(this.stack);
    }

    @Override
    public int baseElementHashCode() {
        return this.elementHashCode();
    }
}

