/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementComparable;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementError;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CraftingMonitorElementList
implements ICraftingMonitorElementList {
    private final List<ICraftingMonitorElement> elements = new LinkedList<ICraftingMonitorElement>();
    private final Map<String, Map<Integer, ICraftingMonitorElement>> currentStorageLists = new LinkedHashMap<String, Map<Integer, ICraftingMonitorElement>>();

    @Override
    public void add(ICraftingMonitorElement element) {
        ICraftingMonitorElement existingElement;
        Map<Integer, ICraftingMonitorElement> storedElements = this.currentStorageLists.get(element.getBaseId());
        boolean merged = false;
        if (storedElements != null && (existingElement = storedElements.get(element.baseElementHashCode())) != null) {
            if (existingElement instanceof CraftingMonitorElementError) {
                if (element instanceof CraftingMonitorElementError) {
                    ((CraftingMonitorElementError)existingElement).mergeBases(((CraftingMonitorElementError)element).getBase());
                } else {
                    ((CraftingMonitorElementError)existingElement).mergeBases(element);
                }
            } else if (element instanceof CraftingMonitorElementError) {
                ((CraftingMonitorElementError)element).mergeBases(existingElement);
                storedElements.put(element.baseElementHashCode(), element);
            } else {
                existingElement.merge(element);
            }
            merged = true;
        }
        if (!merged) {
            if (storedElements == null) {
                storedElements = new HashMap<Integer, ICraftingMonitorElement>();
            }
            storedElements.put(element.baseElementHashCode(), element);
            this.currentStorageLists.put(element.getBaseId(), storedElements);
        }
    }

    @Override
    public void commit() {
        this.currentStorageLists.values().stream().map(Map::values).flatMap(Collection::stream).forEach(this.elements::add);
        this.currentStorageLists.clear();
    }

    @Override
    public void sort() {
        this.elements.sort((o1, o2) -> {
            if (!(o1 instanceof CraftingMonitorElementError) && !(o1 instanceof ICraftingMonitorElementComparable) || !(o2 instanceof CraftingMonitorElementError) && !(o2 instanceof ICraftingMonitorElementComparable)) {
                return 0;
            }
            ICraftingMonitorElementComparable one = (ICraftingMonitorElementComparable)((Object)(o1 instanceof CraftingMonitorElementError ? ((CraftingMonitorElementError)o1).getBase() : o1));
            ICraftingMonitorElementComparable two = (ICraftingMonitorElementComparable)((Object)(o2 instanceof CraftingMonitorElementError ? ((CraftingMonitorElementError)o2).getBase() : o2));
            if (one.getScheduled() > two.getScheduled()) {
                return -1;
            }
            if (one.getScheduled() < two.getScheduled()) {
                return 1;
            }
            if (one.getProcessing() > two.getProcessing()) {
                return -1;
            }
            if (one.getProcessing() < two.getProcessing()) {
                return 1;
            }
            if (one.getCrafting() > two.getCrafting()) {
                return -1;
            }
            if (one.getCrafting() < two.getCrafting()) {
                return 1;
            }
            if (one.getStored() > two.getStored()) {
                return -1;
            }
            if (one.getStored() < two.getStored()) {
                return 1;
            }
            return 0;
        });
    }

    @Override
    public void clearEmptyElements() {
        this.elements.removeIf(e -> {
            if (!(e instanceof ICraftingMonitorElementComparable)) {
                return false;
            }
            ICraftingMonitorElementComparable element = (ICraftingMonitorElementComparable)((Object)(e instanceof CraftingMonitorElementError ? ((CraftingMonitorElementError)e).getBase() : e));
            return element.getStored() < 1L && element.getCrafting() < 1L && element.getProcessing() < 1L && element.getScheduled() < 1L;
        });
    }

    @Override
    public List<ICraftingMonitorElement> getElements() {
        if (!this.currentStorageLists.isEmpty()) {
            this.commit();
        }
        return this.elements;
    }
}

