/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task;

import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.CraftingTaskError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.Task;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CalculationResult {
    private final IStackList<ItemStack> missingItemStacks = API.instance().createItemStackList();
    private final IStackList<FluidStack> missingFluidStacks = API.instance().createFluidStackList();
    private final List<Task> newTasks = new ObjectArrayList();
    private CraftingTaskError error;

    public CalculationResult() {
    }

    public CalculationResult(CraftingTaskError error) {
        this.error = error;
    }

    public void merge(@Nonnull CalculationResult other) {
        for (StackListEntry<FluidStack> stackListEntry : other.missingFluidStacks.getStacks()) {
            this.missingFluidStacks.add(stackListEntry.getStack(), stackListEntry.getCount());
        }
        for (StackListEntry<FluidStack> stackListEntry : other.missingItemStacks.getStacks()) {
            this.missingItemStacks.add((ItemStack)stackListEntry.getStack(), stackListEntry.getCount());
        }
        if (other.getError() != null) {
            this.error = other.getError();
        }
        this.newTasks.addAll(other.getNewTasks());
    }

    @Nullable
    public CraftingTaskError getError() {
        return this.error;
    }

    public List<Task> getNewTasks() {
        return this.newTasks;
    }

    @Nonnull
    public IStackList<ItemStack> getMissingItemStacks() {
        return this.missingItemStacks;
    }

    @Nonnull
    public IStackList<FluidStack> getMissingFluidStacks() {
        return this.missingFluidStacks;
    }
}

