/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementFluidRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementItemRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.Task;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.DurabilityInput;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.InfiniteInput;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Input;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Output;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingTask
extends Task {
    public static final String TYPE = "crafting";
    private static final String NBT_REMAINDER_ITEM = "RemainderItem";
    @Nullable
    private StackListResult<ItemStack> remainder = null;
    @Nullable
    private List<ItemStack> byProducts;
    private boolean finished = false;

    public CraftingTask(@Nonnull ICraftingPattern pattern, ICraftingRequestInfo requestInfo) {
        super(pattern, requestInfo);
        if (pattern.isProcessing()) {
            throw new IllegalArgumentException("Processing pattern cannot be used for crafting task!");
        }
        this.generateCleanByProducts();
    }

    public CraftingTask(@Nonnull INetwork network, @Nonnull NBTTagCompound compound) throws CraftingTaskReadException {
        super(network, compound);
        if (this.amountNeeded < 1L) {
            this.finished = true;
        }
        if (compound.func_74764_b(NBT_REMAINDER_ITEM)) {
            ItemStack itemStack = new ItemStack(compound.func_74775_l(NBT_REMAINDER_ITEM));
            this.remainder = new StackListResult<ItemStack>(itemStack, itemStack.func_190916_E());
        }
        this.generateCleanByProducts();
    }

    public void generateCleanByProducts() {
        ArrayList<ItemStack> byproducts = new ArrayList<ItemStack>((Collection<ItemStack>)this.pattern.getByproducts());
        byproducts.removeIf(i -> i.func_190926_b() || this.getInputs().stream().filter(input -> input instanceof InfiniteInput || input instanceof DurabilityInput).map(input -> this.getPattern().getInputs().stream().filter(possibilities -> possibilities.stream().anyMatch(possibility -> API.instance().getComparer().isEqual((ItemStack)possibility, input.getCompareableItemStack(), 2 | (input.getCompareableItemStack().func_77984_f() ? 0 : 1)))).findFirst().orElse(null)).filter(Objects::nonNull).flatMap(Collection::stream).anyMatch(itemStack -> API.instance().getComparer().isEqual((ItemStack)i, (ItemStack)itemStack, 2 | (itemStack.func_77984_f() ? 0 : 1))));
        this.byProducts = byproducts;
    }

    @Override
    public int update(@Nonnull INetwork network, @Nonnull ICraftingPatternContainer container, int toCraft) {
        if (this.remainder != null) {
            this.remainder = network.insertItem(this.remainder.getStack(), this.remainder.getCount(), Action.PERFORM);
            return 0;
        }
        if (this.amountNeeded < 1L) {
            this.finished = true;
            return 0;
        }
        if ((long)toCraft > this.amountNeeded) {
            toCraft = (int)this.amountNeeded;
        }
        for (Input input : this.inputs) {
            toCraft = (int)Math.min(input.getMinimumCraftableAmount(), (long)toCraft);
        }
        if (toCraft < 1) {
            return 0;
        }
        for (Input input : this.inputs) {
            input.decreaseInputAmount((long)toCraft * (long)input.getQuantityPerCraft());
        }
        Output output = (Output)this.outputs.get(0);
        ItemStack crafted = ItemHandlerHelper.copyStackWithSize((ItemStack)output.getCompareableItemStack(), (int)(output.getQuantityPerCraft() * toCraft));
        if (this.byProducts != null && !this.byProducts.isEmpty()) {
            for (ItemStack byproduct : this.byProducts) {
                network.insertItem(byproduct, toCraft * byproduct.func_190916_E(), Action.PERFORM);
            }
        }
        if (!this.getParents().isEmpty()) {
            Iterator<Task> iterator = this.getParents().iterator();
            while (!crafted.func_190926_b() && iterator.hasNext()) {
                iterator.next().supplyInput(crafted);
            }
        }
        if (!crafted.func_190926_b()) {
            this.remainder = network.insertItem(crafted, (long)crafted.func_190916_E(), Action.PERFORM);
        }
        this.amountNeeded -= (long)toCraft;
        if (this.amountNeeded < 1L && this.remainder == null) {
            this.finished = true;
        }
        network.getCraftingManager().onTaskChanged();
        return toCraft;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNbt(@Nonnull NBTTagCompound compound) {
        super.writeToNbt(compound);
        if (this.remainder != null) {
            compound.func_74782_a(NBT_REMAINDER_ITEM, (NBTBase)this.remainder.getFixedStack().func_77955_b(new NBTTagCompound()));
        }
        return compound;
    }

    @Override
    @Nonnull
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        if (this.isFinished()) {
            return Collections.emptyList();
        }
        ObjectArrayList elements = new ObjectArrayList(this.inputs.size());
        for (Input input : this.inputs) {
            if (input instanceof InfiniteInput && !((InfiniteInput)input).containsItem()) continue;
            if (input.isFluid()) {
                elements.add(new CraftingMonitorElementFluidRender(input.getFluidStack(), input.getTotalInputAmount(), 0L, 0L, input.getToCraftAmount()));
                continue;
            }
            elements.add(new CraftingMonitorElementItemRender(input.getCompareableItemStack(), input.getTotalInputAmount(), 0L, 0L, input.getToCraftAmount()));
        }
        return elements;
    }

    @Override
    @Nonnull
    public List<ItemStack> getLooseItemStacks() {
        if (this.remainder != null) {
            return Collections.singletonList(this.remainder.getFixedStack());
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String getTaskType() {
        return TYPE;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

