/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task;

import com.google.common.collect.Sets;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementItemRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementMissingPatternRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.CraftingRequestInfo;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.CalculationResult;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.CraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.ProcessingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.Task;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.DurabilityInput;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.InfiniteInput;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Input;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Output;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementFluidStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementItemStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class MasterCraftingTask
implements ICraftingTask {
    private static final String NBT_QUANTITY = "Quantity";
    private static final String NBT_TASKS = "Tasks";
    private static final String NBT_CAN_UPDATE = "CanUpdate";
    private static final String NBT_TICKS = "Ticks";
    private static final String NBT_EXECUTION_STARTED = "ExecutionStarted";
    private static final String NBT_TOTAL_AMOUNT_NEEDED = "TotalAmountNeeded";
    private static final String NBT_CALCULATION_TIME = "CalculationTime";
    private static final String NBT_UUID = "Uuid";
    private static final String NBT_REQUEST_INFO = "RequestInfo";
    private static final String NBT_CANCELLED = "Cancelled";
    private final List<Task> tasks = new ObjectArrayList();
    private IStackList<ItemStack> missingItemStacks = API.instance().createItemStackList();
    private IStackList<FluidStack> missingFluidStacks = API.instance().createFluidStackList();
    private final INetwork network;
    private final ICraftingRequestInfo info;
    private UUID id = UUID.randomUUID();
    private final long quantity;
    private long executionStarted = -1L;
    private long calculationTime = -1L;
    private long ticks;
    private boolean canUpdate;
    private boolean cancelled;
    private long totalAmountNeeded;
    private int completionPercentage;
    private ItemStack missingPatternStack;
    private boolean halted;

    public MasterCraftingTask(@Nonnull INetwork network, @Nonnull ICraftingRequestInfo requested, @Nonnull ICraftingPattern pattern) {
        this.network = network;
        this.info = requested;
        long outputPerCraft = 0L;
        if (requested.getItem() != null) {
            outputPerCraft += pattern.getOutputs().stream().filter(o -> API.instance().getComparer().isEqualNoQuantity((ItemStack)o, requested.getItem())).mapToLong(ItemStack::func_190916_E).sum();
            if (pattern.isProcessing()) {
                outputPerCraft -= pattern.getInputs().stream().filter(list -> list.stream().anyMatch(i -> API.instance().getComparer().isEqualNoQuantity((ItemStack)i, requested.getItem()))).mapToLong(list -> ((ItemStack)list.get(0)).func_190916_E()).sum();
            }
        } else {
            outputPerCraft += pattern.getFluidOutputs().stream().filter(o -> API.instance().getComparer().isEqual((FluidStack)o, requested.getFluid(), 2)).mapToLong(o -> o.amount).sum();
            if (pattern.isProcessing()) {
                outputPerCraft -= pattern.getFluidInputs().stream().filter(o -> API.instance().getComparer().isEqual((FluidStack)o, requested.getFluid(), 2)).mapToLong(o -> o.amount).sum();
            }
        }
        this.quantity = requested.getQuantity() % outputPerCraft == 0L ? requested.getQuantity() : (requested.getQuantity() / outputPerCraft + 1L) * outputPerCraft;
        ICraftingRequestInfo requestInfo = requested.getItem() != null ? API.instance().createCraftingRequestInfo(requested.getItem(), this.quantity) : API.instance().createCraftingRequestInfo(requested.getFluid(), this.quantity);
        if (pattern.isProcessing()) {
            this.tasks.add(new ProcessingTask(pattern, requestInfo));
        } else {
            this.tasks.add(new CraftingTask(pattern, requestInfo));
        }
    }

    public MasterCraftingTask(@Nonnull INetwork network, @Nonnull NBTTagCompound compound) throws CraftingTaskReadException {
        this.network = network;
        this.executionStarted = compound.func_74763_f(NBT_EXECUTION_STARTED);
        this.calculationTime = compound.func_74763_f(NBT_CALCULATION_TIME);
        this.totalAmountNeeded = compound.func_74763_f(NBT_TOTAL_AMOUNT_NEEDED);
        this.canUpdate = compound.func_74767_n(NBT_CAN_UPDATE);
        this.cancelled = compound.func_74767_n(NBT_CANCELLED);
        this.quantity = compound.func_74762_e(NBT_QUANTITY);
        this.ticks = compound.func_74763_f(NBT_TICKS);
        this.info = new CraftingRequestInfo(compound.func_74775_l(NBT_REQUEST_INFO));
        this.id = compound.func_186857_a(NBT_UUID);
        NBTTagList list = compound.func_150295_c(NBT_TASKS, 10);
        if (list.func_74745_c() < 1) {
            throw new CraftingTaskReadException("List of sub tasks is empty");
        }
        Object2ObjectLinkedOpenHashMap taskMap = new Object2ObjectLinkedOpenHashMap();
        HashMap parentMap = new HashMap();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Task newTask;
            NBTTagCompound taskCompound = list.func_150305_b(i);
            String type = taskCompound.func_74779_i("TaskType");
            switch (type) {
                case "crafting": {
                    newTask = new CraftingTask(network, taskCompound);
                    break;
                }
                case "processing": {
                    newTask = new ProcessingTask(network, taskCompound);
                    break;
                }
                default: {
                    throw new CraftingTaskReadException("Unknown task type: " + type);
                }
            }
            taskMap.put(newTask.getUuid(), newTask);
            if (!taskCompound.func_74764_b("ParentUuids")) continue;
            ArrayList<UUID> parentUuids = new ArrayList<UUID>();
            NBTTagList parentsTagList = taskCompound.func_150295_c("ParentUuids", 10);
            if (parentsTagList.func_74745_c() < 1) {
                throw new CraftingTaskReadException("Parents tag exists but is empty");
            }
            for (int j = 0; j < parentsTagList.func_74745_c(); ++j) {
                parentUuids.add(parentsTagList.func_150305_b(j).func_186857_a(NBT_UUID));
            }
            parentMap.put(newTask.getUuid(), parentUuids);
        }
        for (Map.Entry uuidListEntry : parentMap.entrySet()) {
            List parents = (List)uuidListEntry.getValue();
            Task child = (Task)taskMap.get(uuidListEntry.getKey());
            for (UUID uuid : parents) {
                Task parent = (Task)taskMap.get(uuid);
                if (child.getUuid().equals(uuid)) {
                    throw new CraftingTaskReadException("Parent of task is itself");
                }
                if (parent == null) {
                    throw new CraftingTaskReadException("Task references parent that doesn't exist");
                }
                child.addParent(parent);
            }
        }
        this.tasks.addAll(taskMap.values());
    }

    @Override
    public boolean update() {
        if (!this.canUpdate) {
            return false;
        }
        if (this.executionStarted == -1L) {
            this.executionStarted = System.currentTimeMillis();
        }
        boolean allFinished = true;
        long totalAmount = 0L;
        for (int i = this.tasks.size() - 1; i >= 0; --i) {
            Task task = this.tasks.get(i);
            if (task.isFinished()) continue;
            Set<ICraftingPatternContainer> containers = this.network.getCraftingManager().getAllContainer(task.getPattern());
            int[] actualUpdateCounts = null;
            if (task instanceof ProcessingTask) {
                ProcessingTask pTask = (ProcessingTask)task;
                actualUpdateCounts = this.splitBetweenCraftingPatternContainers(pTask, containers);
            }
            int j = -1;
            for (ICraftingPatternContainer container : containers) {
                int remainingUpdates;
                ++j;
                if (this.ticks % (long)container.getUpdateInterval() != 0L || (remainingUpdates = container.getCraftingUpdatesLeft()) < 1) continue;
                if (actualUpdateCounts != null) {
                    remainingUpdates = actualUpdateCounts[j];
                }
                container.useCraftingUpdates(task.update(this.network, container, remainingUpdates));
                if (!task.isFinished()) continue;
                break;
            }
            totalAmount += task.getAmountNeeded();
            if (task.isFinished()) continue;
            allFinished = false;
        }
        this.completionPercentage = (int)(100.0 - Math.ceil((double)totalAmount * 100.0 / (double)this.totalAmountNeeded));
        ++this.ticks;
        return allFinished;
    }

    private int[] splitBetweenCraftingPatternContainers(ProcessingTask task, Set<ICraftingPatternContainer> containers) {
        if (containers.size() < 2) {
            return null;
        }
        int total = 0;
        for (ICraftingPatternContainer container : containers) {
            total += container.getCraftingUpdatesLeft();
        }
        boolean seen = false;
        long best = 0L;
        List<Input> inputs = task.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Input in = inputs.get(i);
            long l = in.getTotalInputAmount() / (long)in.getQuantityPerCraft();
            if (seen && l >= best) continue;
            seen = true;
            best = l;
        }
        if (!seen) {
            throw new IllegalStateException();
        }
        if ((total = (int)Math.min((long)total, best)) < 1) {
            return null;
        }
        LinkedList<Pair> queue = new LinkedList<Pair>();
        ICraftingPatternContainer[] array = containers.toArray(new ICraftingPatternContainer[0]);
        if (task.getCrafterIndex() >= array.length) {
            task.setCrafterIndex(0);
        }
        for (int i = task.getCrafterIndex(); i < array.length; ++i) {
            ICraftingPatternContainer filteredContainer = array[i];
            if (filteredContainer.getCraftingUpdatesLeft() > 0 && this.ticks % (long)filteredContainer.getUpdateInterval() == 0L) {
                queue.offerLast(Pair.of((Object)filteredContainer, (Object)i));
            }
            if (task.getCrafterIndex() != 0 && i == task.getCrafterIndex() - 1) break;
            if (task.getCrafterIndex() == 0 || i != array.length - 1) continue;
            i = -1;
        }
        int[] actualUpdateCounts = new int[array.length];
        while (!queue.isEmpty()) {
            int index;
            Pair c = (Pair)queue.pollFirst();
            int n = index = ((Integer)c.getRight()).intValue();
            actualUpdateCounts[n] = actualUpdateCounts[n] + 1;
            if (--total < 1) {
                task.setCrafterIndex(index + 1);
                break;
            }
            if (((ICraftingPatternContainer)c.getLeft()).getCraftingUpdatesLeft() - actualUpdateCounts[index] <= 0) continue;
            queue.offerLast(c);
        }
        return actualUpdateCounts;
    }

    @Override
    public ICraftingTaskError calculate() {
        long calculationStarted = System.currentTimeMillis();
        Task rootTask = this.tasks.get(0);
        CalculationResult result = rootTask.calculate(this.network, (List<ItemStack>)new ObjectArrayList(), Sets.newHashSet((Object[])new ICraftingPattern[]{rootTask.getPattern()}), calculationStarted);
        if (result.getError() == null) {
            this.tasks.addAll(result.getNewTasks());
            this.missingItemStacks = result.getMissingItemStacks();
            this.missingFluidStacks = result.getMissingFluidStacks();
            this.calculationTime = System.currentTimeMillis() - calculationStarted;
            this.totalAmountNeeded = this.tasks.stream().mapToLong(Task::getAmountNeeded).sum();
        }
        if (result.getError() != null || this.hasMissing()) {
            this.onCancelled();
        }
        return result.getError();
    }

    @Override
    public void onCancelled() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        for (Task task : this.tasks) {
            for (ItemStack looseItemStack : task.getLooseItemStacks()) {
                this.network.insertItem(looseItemStack, (long)looseItemStack.func_190916_E(), Action.PERFORM);
            }
            for (FluidStack looseFluidStack : task.getLooseFluidStacks()) {
                this.network.insertFluid(looseFluidStack, (long)looseFluidStack.amount, Action.PERFORM);
            }
            for (Input input : task.getInputs()) {
                long amount;
                boolean isDurabilityInput = input instanceof DurabilityInput;
                if (input instanceof InfiniteInput && !((InfiniteInput)input).containsItem()) continue;
                List<ItemStack> itemStacks = input.getItemStacks();
                for (int i = 0; i < itemStacks.size(); ++i) {
                    ItemStack itemStack = itemStacks.get(i);
                    long amount2 = 1L;
                    if (!isDurabilityInput) {
                        amount2 = input.getCurrentInputCounts().getLong(i);
                    } else {
                        itemStack.func_77964_b(itemStack.func_77958_k() - (int)input.getCurrentInputCounts().getLong(i) + 1);
                    }
                    if (amount2 <= 0L || isDurabilityInput && itemStack.func_77952_i() > itemStack.func_77958_k()) continue;
                    this.network.insertItem(itemStack, amount2, Action.PERFORM);
                }
                if (!input.isFluid() || (amount = input.getCurrentInputCounts().getLong(0)) <= 0L) continue;
                this.network.insertFluid(input.getFluidStack(), amount, Action.PERFORM);
            }
        }
    }

    @Override
    public void updateHaltedState() {
        for (Task task : this.tasks) {
            if (task.isFinished() || this.network.getCraftingManager().getPatterns().contains(task.getPattern())) continue;
            this.halted = true;
            this.missingPatternStack = task.getPattern().getStack();
            return;
        }
        this.halted = false;
        this.missingPatternStack = null;
    }

    @Override
    public boolean isHalted() {
        return this.halted;
    }

    @Override
    public int onTrackedInsert(ItemStack stack, int trackedAmount) {
        for (int i = this.tasks.size() - 1; i >= 0; --i) {
            Task task = this.tasks.get(i);
            if (!(task instanceof ProcessingTask)) continue;
            int oldStackSize = stack.func_190916_E();
            trackedAmount = ((ProcessingTask)task).supplyOutput(stack, trackedAmount);
            if (oldStackSize != stack.func_190916_E()) {
                trackedAmount = Math.max(trackedAmount - (oldStackSize - stack.func_190916_E()), 0);
            }
            if (stack.func_190926_b()) break;
        }
        return trackedAmount;
    }

    @Override
    public int onTrackedInsert(FluidStack stack, int trackedAmount) {
        for (int i = this.tasks.size() - 1; i >= 0; --i) {
            Task task = this.tasks.get(i);
            if (!(task instanceof ProcessingTask)) continue;
            int oldStackSize = stack.amount;
            trackedAmount = ((ProcessingTask)task).supplyOutput(stack, trackedAmount);
            if (oldStackSize != stack.amount) {
                trackedAmount = Math.max(trackedAmount - (oldStackSize - stack.amount), 0);
            }
            if (stack.amount < 1) break;
        }
        return trackedAmount;
    }

    @Override
    public NBTTagCompound writeToNbt(NBTTagCompound compound) {
        compound.func_186854_a(NBT_UUID, this.id);
        compound.func_74772_a(NBT_QUANTITY, this.quantity);
        compound.func_74772_a(NBT_CALCULATION_TIME, this.calculationTime);
        compound.func_74772_a(NBT_EXECUTION_STARTED, this.executionStarted);
        compound.func_74772_a(NBT_TOTAL_AMOUNT_NEEDED, this.totalAmountNeeded);
        compound.func_74757_a(NBT_CAN_UPDATE, this.canUpdate);
        compound.func_74757_a(NBT_CANCELLED, this.cancelled);
        compound.func_74772_a(NBT_TICKS, this.ticks);
        compound.func_74782_a(NBT_REQUEST_INFO, (NBTBase)this.info.writeToNbt());
        NBTTagList list = new NBTTagList();
        for (Task task : this.tasks) {
            list.func_74742_a((NBTBase)task.writeToNbt(new NBTTagCompound()));
        }
        compound.func_74782_a(NBT_TASKS, (NBTBase)list);
        return compound;
    }

    @Override
    public List<ICraftingPreviewElement<?>> getPreviewStacks() {
        ICraftingPreviewElement<ItemStack> element;
        ArrayList elements = new ArrayList(50);
        if (this.info.getItem() != null) {
            elements.add(new CraftingPreviewElementItemStack(this.info.getItem(), 0L, false, this.quantity));
        } else if (this.info.getFluid() != null) {
            elements.add(new CraftingPreviewElementFluidStack(this.info.getFluid(), 0L, false, this.quantity));
        }
        for (StackListEntry<ItemStack> stackListEntry : this.missingItemStacks.getStacks()) {
            ItemStack itemStack = stackListEntry.getStack();
            element = new CraftingPreviewElementItemStack(itemStack, 0L, true, stackListEntry.getCount());
            elements.add(element);
        }
        for (StackListEntry<ItemStack> stackListEntry : this.missingFluidStacks.getStacks()) {
            FluidStack fluidStack = (FluidStack)stackListEntry.getStack();
            element = new CraftingPreviewElementFluidStack(fluidStack, 0L, true, stackListEntry.getCount());
            elements.add(element);
        }
        for (Task task : this.tasks) {
            for (Input input : task.getInputs()) {
                long l;
                boolean merged = false;
                for (ICraftingPreviewElement iCraftingPreviewElement : elements) {
                    ICraftingPreviewElement<FluidStack> previewElement;
                    if (input.isFluid() && iCraftingPreviewElement instanceof CraftingPreviewElementFluidStack) {
                        previewElement = (CraftingPreviewElementFluidStack)iCraftingPreviewElement;
                        if (!API.instance().getComparer().isEqual(input.getFluidStack(), ((CraftingPreviewElementFluidStack)previewElement).getElement(), 2)) continue;
                        ((CraftingPreviewElementFluidStack)previewElement).addAvailable(input.getTotalInputAmount());
                        ((CraftingPreviewElementFluidStack)previewElement).addToCraft(input.getToCraftAmount());
                        merged = true;
                        break;
                    }
                    if (input.isFluid() || !(iCraftingPreviewElement instanceof CraftingPreviewElementItemStack)) continue;
                    previewElement = (CraftingPreviewElementItemStack)iCraftingPreviewElement;
                    boolean isDurabilityInput = input instanceof DurabilityInput;
                    if (!API.instance().getComparer().isEqualNoQuantity(input.getCompareableItemStack(), ((CraftingPreviewElementItemStack)previewElement).getElement())) continue;
                    if (!(input instanceof InfiniteInput) || ((InfiniteInput)input).containsItem()) {
                        ((CraftingPreviewElementItemStack)previewElement).addAvailable(isDurabilityInput ? ((DurabilityInput)input).getTotalItemInputAmount() : input.getTotalInputAmount());
                    }
                    ((CraftingPreviewElementItemStack)previewElement).addToCraft(input.getToCraftAmount());
                    merged = true;
                    break;
                }
                if (merged) continue;
                if (input.isFluid()) {
                    elements.add(new CraftingPreviewElementFluidStack(input.getFluidStack(), input.getTotalInputAmount(), false, input.getToCraftAmount()));
                    continue;
                }
                boolean isDurabilityInput = input instanceof DurabilityInput;
                long l2 = l = isDurabilityInput ? ((DurabilityInput)input).getTotalItemInputAmount() : input.getTotalInputAmount();
                if (input instanceof InfiniteInput && !((InfiniteInput)input).containsItem()) {
                    l = 0L;
                }
                elements.add(new CraftingPreviewElementItemStack(input.getCompareableItemStack(), l, false, input.getToCraftAmount()));
            }
        }
        return elements;
    }

    @Override
    public void setCanUpdate(boolean canUpdate) {
        this.canUpdate = canUpdate;
    }

    @Override
    public boolean canUpdate() {
        return this.canUpdate;
    }

    @Override
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        ICraftingMonitorElementList elements = API.instance().createCraftingMonitorElementList();
        if (!this.isHalted()) {
            List<Task> taskList = this.tasks;
            for (int i = 0; i < taskList.size(); ++i) {
                Task task = taskList.get(i);
                if (i == 0 && task instanceof CraftingTask) {
                    Output output = task.getOutputs().get(0);
                    elements.add(new CraftingMonitorElementItemRender(output.getCompareableItemStack(), 0L, 0L, 0L, task.getAmountNeeded() * (long)output.getQuantityPerCraft()));
                }
                for (ICraftingMonitorElement craftingMonitorElement : task.getCraftingMonitorElements()) {
                    elements.add(craftingMonitorElement);
                }
            }
        } else {
            elements.add(new CraftingMonitorElementMissingPatternRender(this.missingPatternStack));
        }
        elements.commit();
        elements.clearEmptyElements();
        elements.sort();
        return elements.getElements();
    }

    @Override
    public int getCompletionPercentage() {
        return this.completionPercentage;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public ICraftingRequestInfo getRequested() {
        return this.info;
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.tasks.get(0).getPattern();
    }

    @Override
    public long getExecutionStarted() {
        return this.executionStarted;
    }

    @Override
    public IStackList<ItemStack> getMissing() {
        return this.missingItemStacks;
    }

    @Override
    public IStackList<FluidStack> getMissingFluids() {
        return this.missingFluidStacks;
    }

    @Override
    public long getQuantity() {
        return this.quantity;
    }

    @Override
    public long getCalculationTime() {
        return this.calculationTime;
    }
}

