/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs;

import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Input;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class InfiniteInput
extends Input {
    public static final String TYPE = "infinite";
    private static final String NBT_CONTAINS_ITEM = "ContainsItem";
    private boolean containsItem;

    public InfiniteInput(@Nonnull ItemStack itemStack) {
        super((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{itemStack}), 1L);
    }

    public InfiniteInput(@Nonnull NBTTagCompound compound) throws CraftingTaskReadException {
        super(compound);
        this.containsItem = compound.func_74764_b(NBT_CONTAINS_ITEM);
    }

    @Override
    public void decreaseInputAmount(long amount) {
    }

    @Override
    public void decreaseToCraftAmount(@Nonnull ItemStack stack) {
        super.decreaseToCraftAmount(stack);
        this.setContainsItem(true);
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNbt(@Nonnull NBTTagCompound compound) {
        super.writeToNbt(compound);
        if (this.containsItem) {
            compound.func_74757_a(NBT_CONTAINS_ITEM, true);
        }
        return compound;
    }

    @Override
    @Nonnull
    public String getType() {
        return TYPE;
    }

    @Override
    public long getAmountNeeded() {
        return 1L;
    }

    @Override
    public void setAmountNeeded(long amountNeeded) {
    }

    @Override
    public int getQuantityPerCraft() {
        return 0;
    }

    @Override
    public long getMinimumCraftableAmount() {
        return Long.MAX_VALUE;
    }

    public boolean containsItem() {
        return this.containsItem;
    }

    public void setContainsItem(boolean containsItem) {
        this.containsItem = containsItem;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfiniteInput that = (InfiniteInput)o;
        return this.containsItem == that.containsItem;
    }

    public int hashCode() {
        return super.hashCode() * (this.containsItem ? 2 : 1);
    }
}

