/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.energy;

import com.raoulvdberge.refinedstorage.api.energy.IEnergy;
import com.raoulvdberge.refinedstorage.api.util.Action;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;

public final class Energy
implements IEnergy {
    private static final UUID DEFAULT_UUID = new UUID(0L, 0L);
    protected int capacity;
    protected int energyStored;
    private final Map<UUID, Integer> storages = new Object2ObjectOpenHashMap();

    public Energy(int controllerCapacity) {
        this.storages.put(DEFAULT_UUID, controllerCapacity);
        this.calculateCapacity();
    }

    private void calculateCapacity() {
        long newCapacity = this.storages.values().stream().mapToLong(Long::valueOf).sum();
        this.capacity = (int)Math.min(newCapacity, Integer.MAX_VALUE);
    }

    @Override
    public void removeCapacity(UUID id, int amount) {
        if (id.equals(DEFAULT_UUID)) {
            return;
        }
        this.storages.remove(id);
        this.calculateCapacity();
    }

    @Override
    public int extract(int maxExtract, Action action) {
        if (maxExtract <= 0) {
            return 0;
        }
        int extracted = Math.min(this.energyStored, maxExtract);
        if (action == Action.PERFORM) {
            this.energyStored -= extracted;
        }
        return extracted;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getStored() {
        return this.energyStored;
    }

    @Override
    public void addCapacity(UUID id, int amount) {
        if (id.equals(DEFAULT_UUID) || amount <= 0) {
            return;
        }
        this.storages.merge(id, amount, (k, v) -> amount);
        this.calculateCapacity();
    }

    @Override
    public int insert(int maxReceive, Action action) {
        if (maxReceive <= 0) {
            return 0;
        }
        int inserted = Math.min(this.capacity - this.energyStored, maxReceive);
        if (action == Action.PERFORM) {
            this.energyStored += inserted;
        }
        return inserted;
    }

    @Override
    public void setStored(int amount) {
        this.energyStored = Math.min(amount, this.capacity);
    }
}

