/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network;

import com.google.common.collect.Sets;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraph;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraphListener;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NetworkNodeGraph
implements INetworkNodeGraph {
    private final INetwork network;
    private Set<INetworkNode> nodes = Collections.newSetFromMap(new ConcurrentHashMap(1, 1.0f));
    private Set<INetworkNode> filteredNodes = Collections.newSetFromMap(new ConcurrentHashMap(1, 1.0f));
    private final List<INetworkNodeGraphListener> listeners = new LinkedList<INetworkNodeGraphListener>();
    private final Set<Consumer<INetwork>> actions = new HashSet<Consumer<INetwork>>();
    private boolean invalidating = false;

    public NetworkNodeGraph(INetwork network) {
        this.network = network;
    }

    @Override
    public void invalidate(Action action, World world, BlockPos origin) {
        Visitor currentVisitor;
        Object node;
        INetworkNodeProxy proxy;
        this.invalidating = true;
        Operator operator = new Operator(action);
        TileEntity tile = world.func_175625_s(origin);
        if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null) && (proxy = (INetworkNodeProxy)tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, null)) != null && (node = proxy.getNode()) instanceof INetworkNodeVisitor) {
            ((INetworkNodeVisitor)node).visit(operator);
        }
        while ((currentVisitor = (Visitor)operator.toCheck.poll()) != null) {
            currentVisitor.visit(operator);
        }
        this.nodes = operator.foundNodes;
        this.filteredNodes = operator.filteredNodes;
        if (action == Action.PERFORM) {
            for (INetworkNode node2 : operator.newNodes) {
                node2.onConnected(this.network);
            }
            for (INetworkNode node2 : operator.previousNodes) {
                node2.onDisconnected(this.network);
            }
            this.actions.forEach(h -> h.accept(this.network));
            this.actions.clear();
            if (!operator.newNodes.isEmpty() || !operator.previousNodes.isEmpty()) {
                this.listeners.forEach(INetworkNodeGraphListener::onChanged);
            }
        }
        this.invalidating = false;
    }

    @Override
    public INetwork getNetworkForBCReasons() {
        return this.network;
    }

    @Override
    public void runActionWhenPossible(Consumer<INetwork> handler) {
        if (this.invalidating) {
            this.actions.add(handler);
        } else {
            handler.accept(this.network);
        }
    }

    @Override
    public Collection<INetworkNode> allActualNodes() {
        return this.nodes;
    }

    @Override
    public Collection<INetworkNode> all() {
        return this.filteredNodes;
    }

    @Override
    public void addListener(INetworkNodeGraphListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void disconnectAll() {
        this.nodes.forEach(n -> n.onDisconnected(this.network));
        this.nodes.clear();
        this.listeners.forEach(INetworkNodeGraphListener::onChanged);
    }

    protected World getWorld() {
        return this.network.world();
    }

    private static class Visitor
    implements INetworkNodeVisitor {
        private final INetworkNode node;
        private final World world;
        private final BlockPos pos;
        private final EnumFacing side;
        private final TileEntity tile;

        Visitor(INetworkNode node, World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            this.node = node;
            this.world = world;
            this.pos = pos;
            this.side = side;
            this.tile = tile;
        }

        @Override
        public void visit(INetworkNodeVisitor.Operator operator) {
            if (this.node instanceof INetworkNodeVisitor) {
                ((INetworkNodeVisitor)((Object)this.node)).visit(operator);
            } else {
                for (EnumFacing checkSide : EnumFacing.field_82609_l) {
                    Object nodeOnSide;
                    INetworkNodeProxy nodeOnSideProxy;
                    if (checkSide == this.side || (nodeOnSideProxy = (INetworkNodeProxy)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast(this.tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, checkSide))) == null || (nodeOnSide = nodeOnSideProxy.getNode()) != this.node) continue;
                    operator.apply(this.world, this.pos.func_177972_a(checkSide), checkSide.func_176734_d());
                }
            }
        }
    }

    private class Operator
    implements INetworkNodeVisitor.Operator {
        private final ObjectSet<INetworkNode> foundNodes;
        private final Set<INetworkNode> filteredNodes = Sets.newConcurrentHashSet();
        private final Set<INetworkNode> newNodes = Sets.newConcurrentHashSet();
        private final Set<INetworkNode> previousNodes;
        private final Queue<Visitor> toCheck = new LinkedList<Visitor>();
        private final Action action;

        public Operator(Action action) {
            this.action = action;
            this.previousNodes = Collections.newSetFromMap(new ConcurrentHashMap(NetworkNodeGraph.this.nodes.size(), 1.0f));
            this.previousNodes.addAll(NetworkNodeGraph.this.nodes);
            this.foundNodes = ObjectSets.synchronize((ObjectSet)new ObjectOpenHashSet(NetworkNodeGraph.this.nodes.size(), 1.0f));
        }

        @Override
        public void apply(World world, BlockPos pos, @Nullable EnumFacing side) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, side)) {
                INetworkNodeProxy otherNodeProxy = (INetworkNodeProxy)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast(tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, side));
                Object otherNode = otherNodeProxy.getNode();
                if (otherNode.getNetwork() != null && !otherNode.getNetwork().equals(NetworkNodeGraph.this.network)) {
                    if (this.action == Action.PERFORM) {
                        this.dropConflictingBlock(world, tile.func_174877_v());
                    }
                    return;
                }
                if (otherNode.getEnergyUsage() != 0) {
                    this.filteredNodes.add((INetworkNode)otherNode);
                }
                if (this.foundNodes.add(otherNode)) {
                    if (!NetworkNodeGraph.this.nodes.contains(otherNode)) {
                        this.newNodes.add((INetworkNode)otherNode);
                    }
                    this.previousNodes.remove(otherNode);
                    this.toCheck.add(new Visitor((INetworkNode)otherNode, world, pos, side, tile));
                }
            }
        }

        private void dropConflictingBlock(World world, BlockPos pos) {
            if (!NetworkNodeGraph.this.network.getPosition().equals((Object)pos)) {
                IBlockState state = world.func_180495_p(pos);
                NonNullList drops = NonNullList.func_191196_a();
                state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, 0);
                world.func_175698_g(pos);
                for (ItemStack drop : drops) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)drop);
                }
            }
        }

        @Override
        public Action getAction() {
            return this.action;
        }
    }
}

