/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeFactory;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class NetworkNodeManager
extends WorldSavedData
implements INetworkNodeManager {
    public static final String NAME = "refinedstorage_nodes";
    private static final String NBT_NODES = "Nodes";
    private static final String NBT_NODE_ID = "Id";
    private static final String NBT_NODE_DATA = "Data";
    private static final String NBT_NODE_POS = "Pos";
    private boolean canReadNodes;
    private NBTTagList nodesTag;
    private final Map<BlockPos, INetworkNode> nodes = new ConcurrentHashMap<BlockPos, INetworkNode>();
    private final Map<BlockPos, INetworkNode> tickableNodes = new ConcurrentHashMap<BlockPos, INetworkNode>();

    public NetworkNodeManager(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_NODES)) {
            this.nodesTag = tag.func_150295_c(NBT_NODES, 10);
            this.canReadNodes = true;
        }
    }

    public void tryReadNodes(World world) {
        if (this.canReadNodes) {
            this.canReadNodes = false;
            this.nodes.clear();
            this.tickableNodes.clear();
            for (int i = 0; i < this.nodesTag.func_74745_c(); ++i) {
                NBTTagCompound nodeTag = this.nodesTag.func_150305_b(i);
                String id = nodeTag.func_74779_i(NBT_NODE_ID);
                NBTTagCompound data = nodeTag.func_74775_l(NBT_NODE_DATA);
                BlockPos pos = BlockPos.func_177969_a((long)nodeTag.func_74763_f(NBT_NODE_POS));
                INetworkNodeFactory factory = API.instance().getNetworkNodeRegistry().get(id);
                if (factory == null) continue;
                INetworkNode node = null;
                try {
                    node = factory.create(data, world, pos);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (node == null) continue;
                this.nodes.put(pos, node);
                if (!node.isTickable()) continue;
                this.tickableNodes.put(pos, node);
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (INetworkNode node : this.all()) {
            try {
                NBTTagCompound nodeTag = new NBTTagCompound();
                nodeTag.func_74778_a(NBT_NODE_ID, node.getId());
                nodeTag.func_74772_a(NBT_NODE_POS, node.getNetworkNodePos().func_177986_g());
                nodeTag.func_74782_a(NBT_NODE_DATA, (NBTBase)node.write(new NBTTagCompound()));
                list.func_74742_a((NBTBase)nodeTag);
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
        tag.func_74782_a(NBT_NODES, (NBTBase)list);
        return tag;
    }

    @Override
    @Nullable
    public INetworkNode getNode(BlockPos pos) {
        return this.nodes.get(pos);
    }

    @Override
    public void removeNode(BlockPos pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        this.nodes.remove(pos);
        this.tickableNodes.remove(pos);
    }

    @Override
    public void setNode(BlockPos pos, INetworkNode node) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        this.nodes.put(pos, node);
        if (node.isTickable()) {
            this.tickableNodes.put(pos, node);
        }
    }

    @Override
    public Collection<INetworkNode> allTickable() {
        return this.tickableNodes.values();
    }

    @Override
    public Collection<INetworkNode> all() {
        return this.nodes.values();
    }

    @Override
    public void markForSaving() {
        this.func_76185_a();
    }
}

