/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.ICraftingGridBehavior;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridNetworkAware;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeGrid;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingGridBehavior
implements ICraftingGridBehavior {
    @Override
    public void onRecipeTransfer(IGridNetworkAware grid, EntityPlayer player, ItemStack[][] recipe) {
        int i;
        INetwork network = grid.getNetwork();
        if (network == null || grid.getCraftingMatrix() == null || grid.getGridType() == GridType.CRAFTING && !network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        for (i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            ItemStack slot = grid.getCraftingMatrix().func_70301_a(i);
            if (slot.func_190926_b() || grid.getGridType() != GridType.CRAFTING) continue;
            StackListResult<ItemStack> remainder = network.insertItem(slot, (long)slot.func_190916_E(), Action.PERFORM);
            if (remainder != null) {
                CraftingGridBehavior.giveToPlayerOrNetwork(slot, player, null);
            }
            grid.getCraftingMatrix().func_70299_a(i, ItemStack.field_190927_a);
        }
        block1: for (i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            ItemStack[] possibilities = recipe[i];
            if (possibilities == null) continue;
            if (grid.getGridType() == GridType.CRAFTING) {
                ItemStack[] itemStackArray = possibilities;
                int n = itemStackArray.length;
                for (int j = 0; j < n; ++j) {
                    ItemStack possibility;
                    StackListResult<ItemStack> took = network.extractItem(possibility, 1L, 2 | ((possibility = itemStackArray[j]).func_77973_b().func_77645_m() ? 0 : 1), Action.PERFORM);
                    if (took == null) continue;
                    grid.getCraftingMatrix().func_70299_a(i, took.getFixedStack());
                    network.getItemStorageTracker().changed(player, took.getFixedStack().func_77946_l());
                    continue block1;
                }
                for (ItemStack possibility : possibilities) {
                    for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                        ItemStack playerStack = player.field_71071_by.func_70301_a(j);
                        if (!API.instance().getComparer().isEqual(possibility, playerStack, 2 | (possibility.func_77973_b().func_77645_m() ? 0 : 1))) continue;
                        grid.getCraftingMatrix().func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)playerStack, (int)1));
                        player.field_71071_by.func_70298_a(j, 1);
                        continue block1;
                    }
                }
                continue;
            }
            if (grid.getGridType() != GridType.PATTERN) continue;
            grid.getCraftingMatrix().func_70299_a(i, possibilities.length == 0 ? ItemStack.field_190927_a : possibilities[0]);
        }
        if (grid.getGridType() == GridType.PATTERN) {
            ((NetworkNodeGrid)grid).setProcessingPattern(false);
            ((NetworkNodeGrid)grid).markNetworkNodeDirty();
        }
    }

    @Override
    public void onCrafted(IGridNetworkAware grid, IRecipe recipe, EntityPlayer player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        NonNullList remainder = recipe.func_179532_b(grid.getCraftingMatrix());
        INetwork network = grid.getNetwork();
        InventoryCrafting matrix = grid.getCraftingMatrix();
        for (int i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            ItemStack slot = matrix.func_70301_a(i);
            if (i < remainder.size() && !((ItemStack)remainder.get(i)).func_190926_b()) {
                if (!slot.func_190926_b() && slot.func_190916_E() > 1) {
                    if (!player.field_71071_by.func_70441_a(((ItemStack)remainder.get(i)).func_77946_l())) {
                        ItemStack remainderStack;
                        ItemStack itemStack = remainderStack = network == null ? ((ItemStack)remainder.get(i)).func_77946_l() : network.insertItem(((ItemStack)remainder.get(i)).func_77946_l(), ((ItemStack)remainder.get(i)).func_190916_E(), Action.PERFORM);
                        if (remainderStack != null && !remainderStack.func_190926_b()) {
                            InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainderStack);
                        }
                    }
                    matrix.func_70298_a(i, 1);
                    continue;
                }
                matrix.func_70299_a(i, ((ItemStack)remainder.get(i)).func_77946_l());
                continue;
            }
            if (slot.func_190926_b()) continue;
            if (slot.func_190916_E() == 1 && network != null) {
                ItemStack refill;
                if (availableItems == null) {
                    refill = network.extractItem(slot, 1, Action.PERFORM);
                } else if (availableItems.getEntry(slot, 3) != null) {
                    refill = availableItems.remove(slot, 1L).getFixedStack();
                    usedItems.add(refill);
                } else {
                    refill = ItemStack.field_190927_a;
                }
                matrix.func_70299_a(i, refill);
                if (refill.func_190926_b()) continue;
                network.getItemStorageTracker().changed(player, refill.func_77946_l());
                continue;
            }
            matrix.func_70298_a(i, 1);
        }
        grid.onCraftingMatrixChanged();
    }

    @Override
    public void onCraftedShift(IGridNetworkAware grid, EntityPlayer player) {
        InventoryCrafting matrix = grid.getCraftingMatrix();
        INetwork network = grid.getNetwork();
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        ItemStack crafted = grid.getCraftingResult().func_70301_a(0);
        int maxCrafted = crafted.func_77976_d();
        int amountCrafted = 0;
        boolean useNetwork = network != null;
        IStackList<ItemStack> availableItems = null;
        if (useNetwork) {
            availableItems = this.createFilteredItemList(network, matrix);
        }
        IStackList<ItemStack> usedItems = API.instance().createItemStackList();
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        do {
            grid.onCrafted(player, availableItems, usedItems);
            craftedItemsList.add(crafted.func_77946_l());
        } while (API.instance().getComparer().isEqual(crafted, grid.getCraftingResult().func_70301_a(0)) && (amountCrafted += crafted.func_190916_E()) < maxCrafted && amountCrafted + crafted.func_190916_E() <= maxCrafted);
        if (useNetwork) {
            usedItems.getStacks().forEach(stack -> network.extractItem((ItemStack)stack.getStack(), stack.getCount(), Action.PERFORM));
        }
        for (ItemStack craftedItem : craftedItemsList) {
            if (player.field_71071_by.func_70441_a(craftedItem.func_77946_l())) continue;
            ItemStack remainder = craftedItem;
            if (useNetwork) {
                remainder = network.insertItem(craftedItem, craftedItem.func_190916_E(), Action.PERFORM);
            }
            if (remainder == null || remainder.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainder);
        }
        crafted.func_77980_a(player.field_70170_p, player, amountCrafted);
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, ItemHandlerHelper.copyStackWithSize((ItemStack)crafted, (int)amountCrafted), (IInventory)grid.getCraftingMatrix());
        ForgeHooks.setCraftingPlayer(null);
    }

    private IStackList<ItemStack> createFilteredItemList(INetwork network, InventoryCrafting matrix) {
        IStackList<ItemStack> availableItems = API.instance().createItemStackList();
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            StackListEntry<ItemStack> entry = network.getItemStorageCache().getList().getEntry(matrix.func_70301_a(i), 3);
            if (entry == null || availableItems.getEntry(entry.getStack(), 3) != null) continue;
            availableItems.add(entry.getStack(), entry.getCount());
        }
        return availableItems;
    }

    @Override
    public void onClear(IGridNetworkAware grid, EntityPlayer player) {
        boolean useNetwork;
        INetwork network = grid.getNetwork();
        InventoryCrafting matrix = grid.getCraftingMatrix();
        boolean bl = useNetwork = network != null && grid.isActive() && network.getSecurityManager().hasPermission(Permission.INSERT, player);
        if (matrix == null) {
            return;
        }
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            ItemStack slot = matrix.func_70301_a(i);
            if (slot.func_190926_b()) continue;
            if (useNetwork) {
                StackListResult<ItemStack> remainder = network.insertItem(slot, (long)slot.func_190916_E(), Action.PERFORM);
                if (remainder != null) {
                    CraftingGridBehavior.giveToPlayerOrNetwork(remainder.getFixedStack(), player, null);
                }
            } else {
                CraftingGridBehavior.giveToPlayerOrNetwork(slot, player, null);
            }
            matrix.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    private static void giveToPlayerOrNetwork(@Nonnull ItemStack itemStack, @Nonnull EntityPlayer player, @Nullable INetwork network) {
        if (!player.field_71071_by.func_70441_a(itemStack)) {
            Object remainingItem = itemStack;
            if (network != null) {
                StackListResult<ItemStack> result = network.insertItem(itemStack, (long)itemStack.func_190916_E(), Action.PERFORM);
                remainingItem = result != null ? result.getFixedStack() : null;
            }
            if (remainingItem != null) {
                InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)remainingItem);
            } else if (network.getItemStorageTracker() != null) {
                network.getItemStorageTracker().changed(player, itemStack);
            }
        }
    }
}

