/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.tuple.Pair;

public class FluidGridHandlerPortable
implements IFluidGridHandler {
    private final IPortableGrid portableGrid;

    public FluidGridHandlerPortable(IPortableGrid portableGrid) {
        this.portableGrid = portableGrid;
    }

    @Override
    public void onExtract(EntityPlayerMP player, UUID id, boolean shift) {
        FluidStack stack = this.portableGrid.getFluidCache().getList().get((FluidStack)id);
        if (stack == null || stack.getCount() < 1000L || this.portableGrid instanceof IGrid && !((IGrid)((Object)this.portableGrid)).isActive()) {
            return;
        }
        if (StackUtils.hasFluidBucket((FluidStack)stack.getStack())) {
            ItemStack bucket = null;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (!API.instance().getComparer().isEqualNoQuantity(StackUtils.EMPTY_BUCKET, slot)) continue;
                bucket = StackUtils.EMPTY_BUCKET.func_77946_l();
                player.field_71071_by.func_70298_a(i, 1);
                break;
            }
            if (bucket != null) {
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                this.portableGrid.getFluidStorageTracker().changed((EntityPlayer)player, ((FluidStack)stack.getStack()).copy());
                StackListResult entry = this.portableGrid.getFluidStorage().extract((FluidStack)stack.getStack(), 1000L, 2, Action.PERFORM);
                if (entry != null) {
                    fluidHandler.fill((FluidStack)entry.getFixedStack(), true);
                }
                if (shift) {
                    if (!player.field_71071_by.func_70441_a(fluidHandler.getContainer().func_77946_l())) {
                        InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)fluidHandler.getContainer());
                    }
                } else {
                    player.field_71071_by.func_70437_b(fluidHandler.getContainer());
                    player.func_71113_k();
                }
                this.portableGrid.drainEnergy(RS.INSTANCE.config.portableGridExtractUsage);
            }
        }
    }

    @Override
    @Nullable
    public ItemStack onInsert(EntityPlayerMP player, ItemStack container) {
        if (this.portableGrid instanceof IGrid && !((IGrid)((Object)this.portableGrid)).isActive()) {
            return container;
        }
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(container, true);
        if (result.getValue() != null && this.portableGrid.getFluidStorage().insert((FluidStack)result.getValue(), ((FluidStack)result.getValue()).amount, Action.SIMULATE) == null) {
            this.portableGrid.getFluidStorageTracker().changed((EntityPlayer)player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(container, false);
            this.portableGrid.getFluidStorage().insert((FluidStack)result.getValue(), ((FluidStack)result.getValue()).amount, Action.PERFORM);
            this.portableGrid.drainEnergy(RS.INSTANCE.config.portableGridInsertUsage);
            return (ItemStack)result.getLeft();
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(EntityPlayerMP player) {
        player.field_71071_by.func_70437_b(StackUtils.nullToEmpty(this.onInsert(player, player.field_71071_by.func_70445_o())));
        player.func_71113_k();
    }

    @Override
    public ItemStack onShiftClick(EntityPlayerMP player, ItemStack container) {
        return StackUtils.nullToEmpty(this.onInsert(player, container));
    }

    @Override
    public void onCraftingPreviewRequested(EntityPlayerMP player, UUID id, int quantity, boolean noPreview) {
    }

    @Override
    public void onCraftingStartRequested(EntityPlayerMP player, UUID id, int quantity) {
    }
}

