/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSTriggers;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementError;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingPreviewResponse;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingStartResponse;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandler
implements IItemGridHandler {
    private final INetwork network;

    public ItemGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(EntityPlayerMP player, ItemStack stack, int preferredSlot, int flags) {
        StackListEntry<ItemStack> entry = this.network.getItemStorageCache().getList().getEntry(stack, 3);
        if (entry != null) {
            this.onExtract(player, entry.getId(), preferredSlot, flags);
        }
    }

    @Override
    public void onExtract(EntityPlayerMP player, UUID id, int preferredSlot, int flags) {
        ItemStack entry = this.network.getItemStorageCache().getList().get((ItemStack)id);
        if (entry == null || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (EntityPlayer)player)) {
            return;
        }
        long itemSize = entry.getCount();
        int maxItemSize = ((ItemStack)entry.getStack()).func_77973_b().getItemStackLimit(((ItemStack)entry.getStack()).func_77946_l());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? !held.func_190926_b() && (!API.instance().getComparer().isEqualNoQuantity((ItemStack)entry.getStack(), held) || held.func_190916_E() + 1 > held.func_77976_d()) : !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        long size = 64L;
        if ((flags & 1) == 1 && itemSize > 1L) {
            size = itemSize / 2L;
            if (size > (long)(maxItemSize / 2) && maxItemSize != 1) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1L;
        }
        size = Math.min(size, (long)maxItemSize);
        this.network.getItemStorageTracker().changed((EntityPlayer)player, ((ItemStack)entry.getStack()).func_77946_l());
        StackListResult<ItemStack> took = this.network.extractItem((ItemStack)entry.getStack(), size, Action.SIMULATE);
        if (took == null) {
            return;
        }
        if ((flags & 4) == 4) {
            IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            if (playerInventory != null) {
                ItemStack remainder;
                if (preferredSlot != -1 && (long)(remainder = playerInventory.insertItem(preferredSlot, took.getFixedStack(), true)).func_190916_E() != took.getCount()) {
                    StackListResult<ItemStack> inserted = this.network.extractItem((ItemStack)entry.getStack(), size - (long)remainder.func_190916_E(), Action.PERFORM);
                    playerInventory.insertItem(preferredSlot, StackListResult.nullToEmpty(inserted), false);
                    took.setCount(remainder.func_190916_E());
                }
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)took.getFixedStack(), (boolean)true);
                took.setCount(took.getCount() - (long)remainder.func_190916_E());
                if (took.getCount() > 0L && (took = this.network.extractItem((ItemStack)entry.getStack(), took.getCount(), Action.PERFORM)) != null && took.getCount() > 0L) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)took.getFixedStack(), (boolean)false);
                }
            }
        } else {
            took = this.network.extractItem((ItemStack)entry.getStack(), size, Action.PERFORM);
            if (took != null) {
                if (single && !held.func_190926_b()) {
                    held.func_190917_f(1);
                } else {
                    player.field_71071_by.func_70437_b(took.getFixedStack());
                }
                player.func_71113_k();
            }
        }
        this.network.getNetworkItemHandler().drainEnergy((EntityPlayer)player, RS.INSTANCE.config.wirelessGridExtractUsage);
    }

    @Override
    public ItemStack onInsert(EntityPlayerMP player, ItemStack stack, boolean single) {
        ItemStack remainder;
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (EntityPlayer)player)) {
            return stack;
        }
        this.grantAdvancement(player);
        this.network.getItemStorageTracker().changed((EntityPlayer)player, stack.func_77946_l());
        if (single) {
            if (this.network.insertItem(stack, 1, Action.SIMULATE) == null) {
                this.network.insertItem(stack, 1, Action.PERFORM);
                stack.func_190918_g(1);
            }
            remainder = stack;
        } else {
            remainder = this.network.insertItem(stack, stack.func_190916_E(), Action.PERFORM);
        }
        this.network.getNetworkItemHandler().drainEnergy((EntityPlayer)player, RS.INSTANCE.config.wirelessGridInsertUsage);
        return remainder;
    }

    @Override
    public void onInsertHeldItem(EntityPlayerMP player, boolean single) {
        if (player.field_71071_by.func_70445_o().func_190926_b() || !this.network.getSecurityManager().hasPermission(Permission.INSERT, (EntityPlayer)player)) {
            return;
        }
        this.grantAdvancement(player);
        ItemStack stack = player.field_71071_by.func_70445_o();
        int size = single ? 1 : stack.func_190916_E();
        this.network.getItemStorageTracker().changed((EntityPlayer)player, stack.func_77946_l());
        if (single) {
            if (this.network.insertItem(stack, size, Action.SIMULATE) == null) {
                this.network.insertItem(stack, size, Action.PERFORM);
                stack.func_190918_g(size);
                if (stack.func_190916_E() == 0) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            }
        } else {
            player.field_71071_by.func_70437_b(StackUtils.nullToEmpty(this.network.insertItem(stack, size, Action.PERFORM)));
        }
        player.func_71113_k();
        this.network.getNetworkItemHandler().drainEnergy((EntityPlayer)player, RS.INSTANCE.config.wirelessGridInsertUsage);
    }

    private void grantAdvancement(EntityPlayerMP player) {
        if (this.network.getItemStorageCache().getList().getStored() > 100000000000L) {
            RSTriggers.ONE_HUNDRED_BILLION_ITEMS_TRIGGER.trigger(player);
        }
    }

    @Override
    public ItemStack onShiftClick(EntityPlayerMP player, ItemStack stack) {
        return StackUtils.nullToEmpty(this.onInsert(player, stack, false));
    }

    @Override
    public void onCraftingPreviewRequested(EntityPlayerMP player, UUID id, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        ItemStack stack = this.network.getItemStorageCache().getCraftablesList().get((ItemStack)id);
        if (stack != null) {
            ICraftingTask task = this.network.getCraftingManager().create((ItemStack)stack.getStack(), (long)quantity);
            if (task == null) {
                return;
            }
            CompletableFuture.supplyAsync(() -> {
                ICraftingTaskError error = task.calculate();
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                    if (error == null && !task.hasMissing()) {
                        this.network.getCraftingManager().add(task);
                    }
                });
                if (error != null) {
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingPreviewResponse(Collections.singletonList(new CraftingPreviewElementError()), task.getId(), task.getCalculationTime(), quantity, false), player);
                } else if (noPreview && !task.hasMissing()) {
                    task.setCanUpdate(true);
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingStartResponse(), player);
                } else {
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingPreviewResponse(task.getPreviewStacks(), task.getId(), task.getCalculationTime(), quantity, false), player);
                }
                return null;
            }).exceptionally(t -> {
                t.printStackTrace();
                task.onCancelled();
                return null;
            });
        }
    }

    @Override
    public void onCraftingRequested(EntityPlayerMP player, UUID id, int quantity) {
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        ICraftingTask task = this.network.getCraftingManager().getTask(id);
        if (task != null) {
            task.setCanUpdate(true);
        }
    }

    @Override
    public void onCraftingCancelRequested(EntityPlayerMP player, @Nullable UUID id) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        this.network.getCraftingManager().cancel(id);
        this.network.getNetworkItemHandler().drainEnergy((EntityPlayer)player, id == null ? RS.INSTANCE.config.wirelessCraftingMonitorCancelAllUsage : RS.INSTANCE.config.wirelessCraftingMonitorCancelUsage);
    }
}

