/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.mojang.authlib.GameProfile;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilter;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileConstructor;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.FilterType;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.config.IUpgradeContainer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeConstructor
extends NetworkNode
implements IRSFilterConfigProvider,
ICoverable,
IUpgradeContainer {
    public static final String ID = "constructor";
    private static final String NBT_DROP = "Drop";
    private static final String NBT_COVERS = "Covers";
    private static final int BASE_SPEED = 20;
    private final ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2, 3, 4);
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterTypeItemsAndFluids().filterTypeItems().allowedFilterModeWhitelist().filterModeWhitelist().filterSizeOne().compareDamageAndNbt().customFilterTypeSupplier(ft -> this.world.field_72995_K ? FilterType.values()[TileConstructor.TYPE.getValue()] : ft).build();
    private boolean drop = false;
    private final CoverManager coverManager = new CoverManager(this);

    public NetworkNodeConstructor(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.constructorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNetworkNode() {
        super.updateNetworkNode();
        if (this.network != null && this.canUpdate() && this.ticks % this.upgrades.getSpeed(20, 4) == 0) {
            FluidStack stack;
            if (this.config.isFilterTypeItem() && !this.config.getItemHandler().getStackInSlot(0).func_190926_b()) {
                ItemStack item = this.config.getItemHandler().getStackInSlot(0);
                IBlockState block = SlotFilter.getBlockState((IBlockAccess)this.world, this.pos.func_177972_a(this.getDirection()), item);
                if (block != null) {
                    if (this.drop) {
                        this.dropItem();
                    } else {
                        this.placeBlock();
                    }
                } else if (item.func_77973_b() == Items.field_151152_bP && !this.drop) {
                    ItemStack took = this.network.extractItem(item, 1, Action.PERFORM);
                    if (!took.func_190926_b()) {
                        this.world.func_72838_d((Entity)new EntityFireworkRocket(this.world, this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ(), took));
                    }
                } else {
                    this.dropItem();
                }
            } else if (this.config.isFilterTypeFluid() && this.config.getFluidHandler().getFluid(0) != null && (stack = this.config.getFluidHandler().getFluid(0)) != null && stack.getFluid().canBePlacedInWorld()) {
                BlockPos front = this.pos.func_177972_a(this.getDirection());
                Block block = stack.getFluid().getBlock();
                if (this.world.func_175623_d(front) && block.func_176196_c(this.world, front)) {
                    StackListEntry<FluidStack> stored = this.network.getFluidStorageCache().getList().getEntry(stack, this.config.getCompare());
                    if (stored != null && stored.getCount() >= 1000L) {
                        FluidStack took = this.network.extractFluid(stack, 1000, this.config.getCompare(), Action.PERFORM);
                        if (took != null) {
                            IBlockState state = block.func_176223_P();
                            if (state.func_177230_c() == Blocks.field_150355_j) {
                                state = Blocks.field_150358_i.func_176223_P();
                            } else if (state.func_177230_c() == Blocks.field_150353_l) {
                                state = Blocks.field_150356_k.func_176223_P();
                            }
                            if (!this.canPlace(front, state)) {
                                return;
                            }
                            this.world.func_180501_a(front, state, 3);
                        }
                    } else if (this.upgrades.hasUpgrade(3)) {
                        this.network.getCraftingManager().request((Object)this, stack, 1000L);
                    }
                }
            }
        }
    }

    private FakePlayer getFakePlayer() {
        PlayerProfileCache profileCache;
        GameProfile profile;
        WorldServer world = (WorldServer)this.world;
        UUID owner = this.getOwner();
        if (owner != null && (profile = (profileCache = world.func_73046_m().func_152358_ax()).func_152652_a(owner)) != null) {
            return FakePlayerFactory.get((WorldServer)world, (GameProfile)profile);
        }
        return FakePlayerFactory.getMinecraft((WorldServer)world);
    }

    private boolean canPlace(BlockPos pos, IBlockState state) {
        BlockEvent.EntityPlaceEvent e = new BlockEvent.EntityPlaceEvent(new BlockSnapshot(this.world, pos, state), this.world.func_180495_p(pos), (Entity)this.getFakePlayer());
        return !MinecraftForge.EVENT_BUS.post((Event)e);
    }

    private void placeBlock() {
        if (this.network == null) {
            return;
        }
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        ItemStack item = this.config.getItemHandler().getStackInSlot(0);
        ItemStack took = this.network.extractItem(item, 1, this.config.getCompare(), Action.SIMULATE);
        if (!took.func_190926_b()) {
            IBlockState state = SlotFilter.getBlockState((IBlockAccess)this.world, front, took);
            if (state != null && this.world.func_175623_d(front) && state.func_177230_c().func_176196_c(this.world, front)) {
                if (!this.canPlace(front, state = state.func_177230_c().getStateForPlacement(this.world, front, this.getDirection(), 0.5f, 0.5f, 0.5f, took.func_77960_j(), (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.world)), EnumHand.MAIN_HAND))) {
                    return;
                }
                took = this.network.extractItem(item, 1, this.config.getCompare(), Action.PERFORM);
                if (!took.func_190926_b()) {
                    if (item.func_77973_b() instanceof ItemBlock) {
                        ((ItemBlock)item.func_77973_b()).placeBlockAt(took, (EntityPlayer)this.getFakePlayer(), this.world, front, this.getDirection(), 0.0f, 0.0f, 0.0f, state);
                    } else {
                        this.world.func_180501_a(front, state, 3);
                        state.func_177230_c().func_180633_a(this.world, front, state, (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.world)), took);
                    }
                    SoundType blockSound = state.func_177230_c().getSoundType(state, this.world, this.pos, null);
                    this.world.func_184133_a(null, front, blockSound.func_185841_e(), SoundCategory.BLOCKS, (blockSound.func_185843_a() + 1.0f) / 2.0f, blockSound.func_185847_b() * 0.8f);
                    if (state.func_177230_c() == Blocks.field_150465_bP) {
                        this.world.func_175656_a(front, this.world.func_180495_p(front).func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)this.getDirection()));
                        TileEntity tile = this.world.func_175625_s(front);
                        if (tile instanceof TileEntitySkull) {
                            TileEntitySkull skullTile = (TileEntitySkull)tile;
                            if (item.func_77952_i() == 3) {
                                GameProfile playerInfo = null;
                                if (item.func_77942_o()) {
                                    NBTTagCompound tag = item.func_77978_p();
                                    if (tag.func_150297_b("SkullOwner", 10)) {
                                        playerInfo = NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("SkullOwner"));
                                    } else if (tag.func_150297_b("SkullOwner", 8) && !tag.func_74779_i("SkullOwner").isEmpty()) {
                                        playerInfo = new GameProfile(null, tag.func_74779_i("SkullOwner"));
                                    }
                                }
                                skullTile.func_152106_a(playerInfo);
                            } else {
                                skullTile.func_152107_a(item.func_77960_j());
                            }
                            Blocks.field_150465_bP.func_180679_a(this.world, front, skullTile);
                        }
                    }
                }
            }
        } else if (this.upgrades.hasUpgrade(3)) {
            ItemStack craft = this.config.getItemHandler().getStackInSlot(0);
            this.network.getCraftingManager().request((Object)this, craft, 1L);
        }
    }

    private void dropItem() {
        if (this.network == null) {
            return;
        }
        ItemStack took = this.network.extractItem(this.config.getItemHandler().getStackInSlot(0), this.upgrades.getItemInteractCount(), Action.PERFORM);
        if (!took.func_190926_b()) {
            BehaviorDefaultDispenseItem.func_82486_a((World)this.world, (ItemStack)took, (int)6, (EnumFacing)this.getDirection(), (IPosition)new PositionImpl(this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ()));
        } else if (this.upgrades.hasUpgrade(3)) {
            ItemStack craft = this.config.getItemHandler().getStackInSlot(0);
            this.network.getCraftingManager().request((Object)this, craft, 1L);
        }
    }

    private double getDispensePositionX() {
        return (double)this.pos.func_177958_n() + 0.5 + 0.8 * (double)this.getDirection().func_82601_c();
    }

    private double getDispensePositionY() {
        return (double)this.pos.func_177956_o() + (this.getDirection() == EnumFacing.DOWN ? 0.45 : 0.5) + 0.8 * (double)this.getDirection().func_96559_d();
    }

    private double getDispensePositionZ() {
        return (double)this.pos.func_177952_p() + 0.5 + 0.8 * (double)this.getDirection().func_82599_e();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_COVERS)) {
            this.coverManager.readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        tag.func_74782_a(NBT_COVERS, (NBTBase)this.coverManager.writeToNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74757_a(NBT_DROP, this.drop);
        tag.func_74782_a("config", (NBTBase)this.config.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_DROP)) {
            this.drop = tag.func_74767_n(NBT_DROP);
        }
        this.config.readFromNBT(tag.func_74775_l("config"));
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.upgrades, this.coverManager.getAsInventory()});
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return this.coverManager.canConduct(direction);
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    @Override
    public ItemHandlerUpgrade getUpgradeHandler() {
        return this.upgrades;
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }

    @Override
    public NBTTagCompound writeExtraNbt(NBTTagCompound tag) {
        tag.func_74757_a("drop", this.drop);
        return tag;
    }

    @Override
    public void readExtraNbt(NBTTagCompound tag) {
        if (tag.func_74764_b("drop")) {
            this.drop = tag.func_74767_n("drop");
        }
    }
}

