/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDiskDrive;
import com.raoulvdberge.refinedstorage.tile.TileImporter;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.FilterType;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.config.IUpgradeContainer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeImporter
extends NetworkNode
implements IRSFilterConfigProvider,
ICoverable,
IUpgradeContainer {
    public static final String ID = "importer";
    private static final String NBT_COVERS = "Covers";
    private final ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2, 4);
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterModeBlackAndWhitelist().filterModeBlacklist().allowedFilterTypeItemsAndFluids().filterTypeItems().filterSizeNine().compareDamageAndNbt().customFilterTypeSupplier(ft -> this.world.field_72995_K ? FilterType.values()[TileImporter.TYPE.getValue()] : ft).build();
    private final CoverManager coverManager = new CoverManager(this);
    private int currentSlot;

    public NetworkNodeImporter(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.importerUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNetworkNode() {
        super.updateNetworkNode();
        if (this.network == null || !this.canUpdate()) {
            return;
        }
        if (this.config.isFilterTypeItem()) {
            TileEntity facing = this.getFacingTile();
            IItemHandler handler = WorldUtils.getItemHandler(facing, this.getDirection().func_176734_d());
            if (facing instanceof TileDiskDrive || handler == null) {
                return;
            }
            int handlerSlotCount = handler.getSlots();
            if (this.currentSlot >= handlerSlotCount) {
                this.currentSlot = 0;
            }
            if (handlerSlotCount > 0) {
                ItemStack stack = handler.getStackInSlot(this.currentSlot);
                while (this.currentSlot + 1 < handlerSlotCount && stack.func_190926_b()) {
                    ++this.currentSlot;
                    stack = handler.getStackInSlot(this.currentSlot);
                }
                if (!this.config.acceptsItem(stack)) {
                    ++this.currentSlot;
                } else if (this.ticks % this.upgrades.getSpeed() == 0) {
                    ItemStack result = handler.extractItem(this.currentSlot, this.upgrades.getItemInteractCount(), true);
                    if (!result.func_190926_b() && this.network.insertItem(result, result.func_190916_E(), Action.SIMULATE) == null) {
                        result = handler.extractItem(this.currentSlot, this.upgrades.getItemInteractCount(), false);
                        if (!result.func_190926_b()) {
                            this.network.insertItemTracked(result, result.func_190916_E());
                        }
                    } else {
                        ++this.currentSlot;
                    }
                }
            }
        } else if (this.config.isFilterTypeFluid() && this.ticks % this.upgrades.getSpeed() == 0) {
            int i;
            IFluidHandler handler = WorldUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d());
            if (handler == null) {
                return;
            }
            IFluidTankProperties[] properties = handler.getTankProperties();
            if (this.currentSlot >= properties.length) {
                this.currentSlot = 0;
            }
            FluidStack stack = null;
            for (i = this.currentSlot; !(i >= properties.length || stack != null && stack.amount >= 1 && this.config.acceptsFluid(stack)); ++i) {
                stack = properties[i].getContents();
                if (this.currentSlot != 0 && i == this.currentSlot - 1) break;
                if (this.currentSlot == 0 || i != properties.length - 1) continue;
                i = -1;
            }
            if (stack == null || stack.amount < 1 || !this.config.acceptsFluid(stack)) {
                ++this.currentSlot;
                return;
            }
            this.currentSlot = i;
            if (this.network.insertFluid(stack, (long)stack.amount, Action.SIMULATE) == null) {
                stack.amount = 1000 * this.upgrades.getItemInteractCount();
                FluidStack toDrain = handler.drain(stack, false);
                if (toDrain != null) {
                    FluidStack remainder = this.network.insertFluidTracked(toDrain, toDrain.amount);
                    if (remainder != null) {
                        toDrain.amount -= remainder.amount;
                    }
                    handler.drain(toDrain, true);
                }
            } else {
                ++this.currentSlot;
            }
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_COVERS)) {
            this.coverManager.readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        tag.func_74782_a(NBT_COVERS, (NBTBase)this.coverManager.writeToNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.upgrades, this.coverManager.getAsInventory()});
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return this.coverManager.canConduct(direction);
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    @Override
    public ItemHandlerUpgrade getUpgradeHandler() {
        return this.upgrades;
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }
}

