/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeExternalStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage.StorageExternalItem;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerProxy;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.config.IUpgradeContainer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeInterface
extends NetworkNode
implements IRSFilterConfigProvider,
IUpgradeContainer {
    public static final String ID = "interface";
    private final ItemHandlerBase importItems = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private final ItemHandlerBase exportItems = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private final IItemHandler items = new ItemHandlerProxy((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
    private final ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2, 4, 3);
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterTypeItems().allowedFilterModeWhitelist().filterSizeNine().compareDamageAndNbt().build();
    private int currentSlot = 0;

    public NetworkNodeInterface(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.interfaceUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNetworkNode() {
        ItemStack slot;
        super.updateNetworkNode();
        if (this.network == null || !this.canUpdate()) {
            return;
        }
        if (this.currentSlot >= this.importItems.getSlots()) {
            this.currentSlot = 0;
        }
        if ((slot = this.importItems.getStackInSlot(this.currentSlot)).func_190926_b()) {
            ++this.currentSlot;
        } else if (this.ticks % this.upgrades.getSpeed() == 0) {
            int size = Math.min(slot.func_190916_E(), this.upgrades.getItemInteractCount());
            ItemStack remainder = this.network.insertItemTracked(slot, size);
            if (remainder == null) {
                this.importItems.extractItem(this.currentSlot, size, false);
            } else if (size - remainder.func_190916_E() > 0) {
                this.importItems.extractItem(this.currentSlot, size - remainder.func_190916_E(), false);
                ++this.currentSlot;
            }
        }
        for (int i = 0; i < 9; ++i) {
            int delta;
            ItemStack wanted = this.config.getItemHandler().getStackInSlot(i);
            ItemStack got = this.exportItems.getStackInSlot(i);
            if (wanted.func_190926_b()) {
                if (got.func_190926_b()) continue;
                this.exportItems.setStackInSlot(i, StackUtils.nullToEmpty(this.network.insertItemTracked(got, got.func_190916_E())));
                continue;
            }
            if (!got.func_190926_b() && !API.instance().getComparer().isEqual(wanted, got, this.config.getCompare())) {
                this.exportItems.setStackInSlot(i, StackUtils.nullToEmpty(this.network.insertItemTracked(got, got.func_190916_E())));
                continue;
            }
            int n = delta = got.func_190926_b() ? wanted.func_190916_E() : wanted.func_190916_E() - got.func_190916_E();
            if (delta > 0) {
                boolean actingAsStorage = this.isActingAsStorage();
                ItemStack result = this.network.extractItem(wanted, delta, this.config.getCompare() | 8, Action.PERFORM, s -> {
                    if (!actingAsStorage) {
                        return true;
                    }
                    return !(s instanceof StorageExternalItem) || !((StorageExternalItem)s).isConnectedToInterface();
                });
                if (!result.func_190926_b()) {
                    if (this.exportItems.getStackInSlot(i).func_190926_b()) {
                        this.exportItems.setStackInSlot(i, result);
                        continue;
                    }
                    if (API.instance().getComparer().isEqualNoQuantity(this.exportItems.getStackInSlot(i), result)) {
                        this.exportItems.getStackInSlot(i).func_190917_f(result.func_190916_E());
                        if ((delta -= result.func_190926_b() ? 0 : result.func_190916_E()) <= 0 || !this.upgrades.hasUpgrade(3)) continue;
                        this.network.getCraftingManager().request((Object)new SlottedCraftingRequest(this, i), wanted, (long)delta);
                        continue;
                    }
                    this.network.insertItem(result, result.func_190916_E(), Action.PERFORM);
                    continue;
                }
                if (!this.upgrades.hasUpgrade(3)) continue;
                this.network.getCraftingManager().request((Object)new SlottedCraftingRequest(this, i), wanted, (long)delta);
                continue;
            }
            if (delta >= 0) continue;
            ItemStack remainder = this.network.insertItemTracked(got, Math.abs(delta));
            if (remainder == null) {
                this.exportItems.extractItem(i, Math.abs(delta), false);
                continue;
            }
            this.exportItems.extractItem(i, Math.abs(delta) - remainder.func_190916_E(), false);
        }
    }

    private boolean isActingAsStorage() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            INetworkNode facingNode = API.instance().getNetworkNodeManager(this.world).getNode(this.pos.func_177972_a(facing));
            if (!(facingNode instanceof NetworkNodeExternalStorage) || !facingNode.canUpdate() || ((NetworkNodeExternalStorage)facingNode).getDirection() != facing.func_176734_d() || !((NetworkNodeExternalStorage)facingNode).getConfig().isFilterTypeItem()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.importItems, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.exportItems, 2, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 3, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.importItems, 0, tag);
        StackUtils.writeItems((IItemHandler)this.exportItems, 2, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
    }

    public IItemHandler getImportItems() {
        return this.importItems;
    }

    public IItemHandler getExportItems() {
        return this.exportItems;
    }

    public IItemHandler getItems() {
        return this.items;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.importItems, this.exportItems, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public ItemHandlerUpgrade getUpgradeHandler() {
        return this.upgrades;
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }
}

