/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkNodeStorageMonitor
extends NetworkNode
implements IRSFilterConfigProvider {
    public static final int DEPOSIT_ALL_MAX_DELAY = 500;
    public static final String ID = "storage_monitor";
    private final Map<String, Pair<ItemStack, Long>> deposits = new HashMap<String, Pair<ItemStack, Long>>();
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterModeWhitelist().allowedFilterTypeItems().filterSizeOne().compareDamageAndNbt().onItemFilterChanged(slot -> WorldUtils.updateBlock(this.world, this.pos)).build();
    private long oldAmount = -1L;

    public NetworkNodeStorageMonitor(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public void updateNetworkNode() {
        super.updateNetworkNode();
        long newAmount = this.getAmount();
        if (this.oldAmount == -1L) {
            this.oldAmount = newAmount;
        } else if (this.oldAmount != newAmount) {
            this.oldAmount = newAmount;
            WorldUtils.updateBlock(this.world, this.pos);
        }
    }

    public boolean depositAll(EntityPlayer player) {
        if (this.network == null) {
            return false;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return false;
        }
        Pair<ItemStack, Long> deposit = this.deposits.get(player.func_146103_bH().getName());
        if (deposit == null) {
            return false;
        }
        ItemStack inserted = (ItemStack)deposit.getKey();
        long insertedAt = (Long)deposit.getValue();
        if (MinecraftServer.func_130071_aq() - insertedAt < 500L) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack toInsert = player.field_71071_by.func_70301_a(i);
                if (!API.instance().getComparer().isEqual(inserted, toInsert, this.config.getCompare())) continue;
                player.field_71071_by.func_70299_a(i, StackUtils.nullToEmpty(this.network.insertItemTracked(toInsert, toInsert.func_190916_E())));
            }
        }
        return true;
    }

    public boolean deposit(EntityPlayer player, ItemStack toInsert) {
        if (this.network == null) {
            return false;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return false;
        }
        ItemStack filter = this.config.getItemHandler().getStackInSlot(0);
        if (!filter.func_190926_b() && API.instance().getComparer().isEqual(filter, toInsert, this.config.getCompare())) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, StackUtils.nullToEmpty(this.network.insertItemTracked(toInsert, toInsert.func_190916_E())));
            this.deposits.put(player.func_146103_bH().getName(), (Pair<ItemStack, Long>)Pair.of((Object)toInsert, (Object)MinecraftServer.func_130071_aq()));
        }
        return true;
    }

    public void extract(EntityPlayer player, EnumFacing side) {
        ItemStack result;
        int toExtract;
        if (this.network == null || this.getDirection() != side) {
            return;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        ItemStack filter = this.config.getItemHandler().getStackInSlot(0);
        int n = toExtract = player.func_70093_af() ? 1 : 64;
        if (!(filter.func_190926_b() || (result = this.network.extractItem(filter, toExtract, this.config.getCompare(), Action.PERFORM)).func_190926_b() || player.field_71071_by.func_70441_a(result.func_77946_l()))) {
            InventoryHelper.func_180173_a((World)this.world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)result);
        }
    }

    @Override
    public int getEnergyUsage() {
        return 0;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
    }

    public long getAmount() {
        if (this.network == null) {
            return 0L;
        }
        ItemStack toCheck = this.config.getItemHandler().getStackInSlot(0);
        if (toCheck.func_190926_b()) {
            return 0L;
        }
        StackListEntry<ItemStack> stored = this.network.getItemStorageCache().getList().getEntry(toCheck, this.config.getCompare());
        return stored != null ? stored.getCount() : 0L;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }
}

