/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.StorageDiskFluidDriveWrapper;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.StorageDiskItemDriveWrapper;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheItem;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDiskDrive;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.FilterType;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeDiskDrive
extends NetworkNode
implements IGuiStorage,
IStorageProvider,
IRSFilterConfigProvider,
IPrioritizable,
IAccessType,
IStorageDiskContainerContext {
    public static final Predicate<ItemStack> VALIDATOR_STORAGE_DISK = s -> s.func_77973_b() instanceof IStorageDiskProvider && ((IStorageDiskProvider)s.func_77973_b()).isValid((ItemStack)s);
    public static final String ID = "disk_drive";
    private static final String NBT_PRIORITY = "Priority";
    private static final int DISK_STATE_UPDATE_THROTTLE = 30;
    private int ticksSinceBlockUpdateRequested;
    private boolean blockUpdateRequested;
    private final ItemHandlerBase disks = new ItemHandlerBase(8, new ListenerNetworkNode(this), new Predicate[]{VALIDATOR_STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                StackUtils.createStorages(NetworkNodeDiskDrive.this.world, this.getStackInSlot(slot), slot, NetworkNodeDiskDrive.this.itemDisks, NetworkNodeDiskDrive.this.fluidDisks, s -> new StorageDiskItemDriveWrapper(NetworkNodeDiskDrive.this, (IStorageDisk<ItemStack>)s), s -> new StorageDiskFluidDriveWrapper(NetworkNodeDiskDrive.this, (IStorageDisk<FluidStack>)s));
                if (NetworkNodeDiskDrive.this.network != null) {
                    NetworkNodeDiskDrive.this.network.getItemStorageCache().invalidate();
                    NetworkNodeDiskDrive.this.network.getFluidStorageCache().invalidate();
                }
                WorldUtils.updateBlock(NetworkNodeDiskDrive.this.world, NetworkNodeDiskDrive.this.pos);
            }
        }
    };
    private final IStorageDisk[] itemDisks = new IStorageDisk[8];
    private final IStorageDisk[] fluidDisks = new IStorageDisk[8];
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterModeBlackAndWhitelist().filterModeBlacklist().allowedFilterTypeItemsAndFluids().filterTypeItems().filterSizeNine().compareDamageAndNbt().customFilterTypeSupplier(ft -> this.world.field_72995_K ? FilterType.values()[TileDiskDrive.TYPE.getValue()] : ft).build();

    public NetworkNodeDiskDrive(World world, BlockPos pos) {
        super(world, pos);
    }

    public IStorageDisk[] getItemDisks() {
        return this.itemDisks;
    }

    public IStorageDisk[] getFluidDisks() {
        return this.fluidDisks;
    }

    @Override
    public int getEnergyUsage() {
        int usage = RS.INSTANCE.config.diskDriveUsage;
        for (IStorageDisk storage : this.itemDisks) {
            if (storage == null) continue;
            usage += RS.INSTANCE.config.diskDrivePerDiskUsage;
        }
        for (IStorageDisk storage : this.fluidDisks) {
            if (storage == null) continue;
            usage += RS.INSTANCE.config.diskDrivePerDiskUsage;
        }
        return usage;
    }

    @Override
    public void updateNetworkNode() {
        super.updateNetworkNode();
        if (this.blockUpdateRequested) {
            ++this.ticksSinceBlockUpdateRequested;
            if (this.ticksSinceBlockUpdateRequested > 30) {
                WorldUtils.updateBlock(this.world, this.pos);
                this.blockUpdateRequested = false;
                this.ticksSinceBlockUpdateRequested = 0;
            }
        } else {
            this.ticksSinceBlockUpdateRequested = 0;
        }
    }

    void requestBlockUpdate() {
        this.blockUpdateRequested = true;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getNodeGraph().runActionWhenPossible(StorageCacheItem.INVALIDATE);
        network.getNodeGraph().runActionWhenPossible(StorageCacheFluid.INVALIDATE);
        WorldUtils.updateBlock(this.world, this.pos);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        for (IStorageDisk storage : this.itemDisks) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        for (IStorageDisk storage : this.fluidDisks) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.disks, 0, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.disks, 0, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:disk_drive.name";
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return TileDiskDrive.TYPE;
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileDiskDrive.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileDiskDrive.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileDiskDrive.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileDiskDrive.PRIORITY;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileDiskDrive.ACCESS_TYPE;
    }

    @Override
    public long getStored() {
        return TileDiskDrive.STORED.getValue();
    }

    @Override
    public long getCapacity() {
        return TileDiskDrive.CAPACITY.getValue();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getFluidStorageCache().invalidate();
            this.network.getItemStorageCache().invalidate();
        }
        this.markNetworkNodeDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markNetworkNodeDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
            this.network.getFluidStorageCache().sort();
        }
    }

    public IItemHandler getDisks() {
        return this.disks;
    }

    @Override
    public IItemHandler getDrops() {
        return this.disks;
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }

    @Override
    public NBTTagCompound writeExtraNbt(NBTTagCompound tag) {
        tag.func_74768_a("accessType", this.accessType.getId());
        return tag;
    }

    @Override
    public void readExtraNbt(NBTTagCompound tag) {
        if (tag.func_74764_b("accessType")) {
            this.accessType = AccessTypeUtils.getAccessType(tag.func_74762_e("accessType"));
        }
    }
}

