/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class StorageCacheFluid
implements IStorageCache<FluidStack> {
    public static final Consumer<INetwork> INVALIDATE = n -> n.getFluidStorageCache().invalidate();
    private final INetwork network;
    private final CopyOnWriteArrayList<IStorage<FluidStack>> storages = new CopyOnWriteArrayList();
    private final IStackList<FluidStack> list = API.instance().createFluidStackList();
    private final IStackList<FluidStack> craftables = API.instance().createFluidStackList();
    private final List<IStorageCacheListener<FluidStack>> listeners = new LinkedList<IStorageCacheListener<FluidStack>>();
    private final List<StackListResult<FluidStack>> batchedChanges = new ArrayList<StackListResult<FluidStack>>();

    public StorageCacheFluid(INetwork network) {
        this.network = network;
    }

    @Override
    public synchronized void invalidate() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IStorageProvider).forEach(node -> ((IStorageProvider)((Object)node)).addFluidStorages(this.storages));
        for (StackListEntry<FluidStack> stackListEntry : this.list.getStacks()) {
            this.batchedChanges.add(new StackListResult<FluidStack>(stackListEntry.getStack(), stackListEntry.getId(), -stackListEntry.getCount()));
        }
        this.list.clearCounts();
        this.sort();
        for (IStorage iStorage : this.storages) {
            if (iStorage.getAccessType() == AccessType.INSERT) continue;
            for (StackListEntry entry : iStorage.getEntries()) {
                FluidStack stack;
                if (entry.getCount() <= 0L || (stack = (FluidStack)entry.getStack()) == null) continue;
                this.add(stack, entry.getCount(), true);
            }
        }
        this.list.clearEmpty();
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
        this.flush();
    }

    @Override
    public synchronized void add(@Nonnull FluidStack stack, long size, boolean batched) {
        StackListResult<FluidStack> result = this.list.add(stack, size);
        if (!batched) {
            this.listeners.forEach(l -> l.onChanged(result));
        } else {
            this.batchedChanges.add(result);
        }
    }

    @Override
    public synchronized void remove(@Nonnull FluidStack stack, long size, boolean batched) {
        StackListResult<FluidStack> result = this.list.remove(stack, size);
        if (result != null) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(result));
            } else {
                this.batchedChanges.add(result);
            }
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.batchedChanges.isEmpty()) {
            if (this.batchedChanges.size() > 1) {
                this.listeners.forEach(l -> l.onChangedBulk(this.batchedChanges));
            } else {
                this.batchedChanges.forEach(change -> this.listeners.forEach(l -> l.onChanged(change)));
            }
            this.batchedChanges.clear();
        }
    }

    @Override
    public void addListener(IStorageCacheListener<FluidStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<FluidStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void reAttachListeners() {
        this.listeners.forEach(IStorageCacheListener::onAttached);
    }

    @Override
    public void sort() {
        this.storages.sort(IStorage.COMPARATOR);
    }

    @Override
    public IStackList<FluidStack> getList() {
        return this.list;
    }

    @Override
    public IStackList<FluidStack> getCraftablesList() {
        return this.craftables;
    }

    @Override
    public List<IStorage<FluidStack>> getStorages() {
        return this.storages;
    }
}

