/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache;

import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class StorageCacheFluidPortable
implements IStorageCache<FluidStack> {
    private final IPortableGrid portableGrid;
    private final IStackList<FluidStack> list = API.instance().createFluidStackList();
    private final List<IStorageCacheListener<FluidStack>> listeners = new LinkedList<IStorageCacheListener<FluidStack>>();

    public StorageCacheFluidPortable(IPortableGrid portableGrid) {
        this.portableGrid = portableGrid;
    }

    @Override
    public void invalidate() {
        this.list.clearCounts();
        if (this.portableGrid.getFluidStorage() != null) {
            for (StackListEntry e : this.portableGrid.getFluidStorage().getEntries()) {
                FluidStack stack;
                if (e.getCount() <= 0L || (stack = (FluidStack)e.getStack()) == null) continue;
                this.list.add(stack, e.getCount());
            }
        }
        this.list.clearEmpty();
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
    }

    @Override
    public void add(@Nonnull FluidStack stack, long size, boolean batched) {
        StackListResult<FluidStack> result = this.list.add(stack, size);
        this.listeners.forEach(l -> l.onChanged(result));
    }

    @Override
    public void remove(@Nonnull FluidStack stack, long size, boolean batched) {
        StackListResult<FluidStack> result = this.list.remove(stack, size);
        if (result != null) {
            this.listeners.forEach(l -> l.onChanged(result));
        }
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Cannot flush portable grid storage cache");
    }

    @Override
    public void addListener(IStorageCacheListener<FluidStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<FluidStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void reAttachListeners() {
        this.listeners.forEach(IStorageCacheListener::onAttached);
    }

    @Override
    public void sort() {
    }

    @Override
    public IStackList<FluidStack> getList() {
        return this.list;
    }

    @Override
    public IStackList<FluidStack> getCraftablesList() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public List<IStorage<FluidStack>> getStorages() {
        return Collections.emptyList();
    }
}

