/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache;

import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class StorageCacheItemPortable
implements IStorageCache<ItemStack> {
    private final IPortableGrid portableGrid;
    private final IStackList<ItemStack> list = API.instance().createItemStackList();
    private final List<IStorageCacheListener<ItemStack>> listeners = new LinkedList<IStorageCacheListener<ItemStack>>();

    public StorageCacheItemPortable(IPortableGrid portableGrid) {
        this.portableGrid = portableGrid;
    }

    @Override
    public void invalidate() {
        this.list.clearCounts();
        if (this.portableGrid.getItemStorage() != null) {
            for (StackListEntry entry : this.portableGrid.getItemStorage().getEntries()) {
                if (entry == null || ((ItemStack)entry.getStack()).func_190926_b() || entry.getCount() <= 0L) continue;
                this.list.add((ItemStack)entry.getStack(), entry.getCount());
            }
        }
        this.list.clearEmpty();
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
    }

    @Override
    public void add(@Nonnull ItemStack stack, long size, boolean batched) {
        StackListResult<ItemStack> result = this.list.add(stack, size);
        this.listeners.forEach(l -> l.onChanged(result));
    }

    @Override
    public void remove(@Nonnull ItemStack stack, long size, boolean batched) {
        StackListResult<ItemStack> result = this.list.remove(stack, size);
        if (result != null) {
            this.listeners.forEach(l -> l.onChanged(result));
        }
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Cannot flush portable grid storage cache");
    }

    @Override
    public void addListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void reAttachListeners() {
        this.listeners.forEach(IStorageCacheListener::onAttached);
    }

    @Override
    public void sort() {
    }

    @Override
    public IStackList<ItemStack> getList() {
        return this.list;
    }

    @Override
    public IStackList<ItemStack> getCraftablesList() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public List<IStorage<ItemStack>> getStorages() {
        return Collections.emptyList();
    }
}

