/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.network.MessagePortableGridFluidDelta;
import com.raoulvdberge.refinedstorage.network.MessagePortableGridFluidUpdate;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StorageCacheListenerGridPortableFluid
implements IStorageCacheListener<FluidStack> {
    private final IPortableGrid portableGrid;
    private final EntityPlayerMP player;

    public StorageCacheListenerGridPortableFluid(IPortableGrid portableGrid, EntityPlayerMP player) {
        this.portableGrid = portableGrid;
        this.player = player;
    }

    @Override
    public void onAttached() {
        RS.INSTANCE.network.sendTo((IMessage)new MessagePortableGridFluidUpdate(this.portableGrid), this.player);
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(@Nonnull StackListResult<FluidStack> delta) {
        ArrayList<StackListResult<FluidStack>> deltas = new ArrayList<StackListResult<FluidStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<FluidStack>>)deltas);
    }

    @Override
    public void onChangedBulk(@Nonnull List<StackListResult<FluidStack>> storageCacheDeltas) {
        RS.INSTANCE.network.sendTo((IMessage)new MessagePortableGridFluidDelta(this.portableGrid, storageCacheDeltas), this.player);
    }
}

