/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.network.MessagePortableGridItemDelta;
import com.raoulvdberge.refinedstorage.network.MessagePortableGridItemUpdate;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StorageCacheListenerGridPortableItem
implements IStorageCacheListener<ItemStack> {
    private final IPortableGrid portableGrid;
    private final EntityPlayerMP player;

    public StorageCacheListenerGridPortableItem(IPortableGrid portableGrid, EntityPlayerMP player) {
        this.portableGrid = portableGrid;
        this.player = player;
    }

    @Override
    public void onAttached() {
        RS.INSTANCE.network.sendTo((IMessage)new MessagePortableGridItemUpdate(this.portableGrid), this.player);
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(@Nonnull StackListResult<ItemStack> delta) {
        ArrayList<StackListResult<ItemStack>> deltas = new ArrayList<StackListResult<ItemStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<ItemStack>>)deltas);
    }

    @Override
    public void onChangedBulk(@Nonnull List<StackListResult<ItemStack>> storageCacheDeltas) {
        RS.INSTANCE.network.sendTo((IMessage)new MessagePortableGridItemDelta(this.portableGrid, storageCacheDeltas), this.player);
    }
}

