/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.util.StackListItem;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class StorageDiskItem
implements IStorageDisk<ItemStack> {
    public static final String NBT_VERSION = "Version";
    public static final String NBT_CAPACITY = "Capacity";
    public static final String NBT_ITEMS = "Items";
    public static final String NBT_REAL_SIZE = "RealSize";
    private final World world;
    private final long capacity;
    private long stored;
    private final Map<StackListItem.ItemStackWrapper, StackListEntry<ItemStack>> stacks = new ConcurrentHashMap<StackListItem.ItemStackWrapper, StackListEntry<ItemStack>>();
    private final Multimap<Item, StackListItem.ItemStackWrapper> stacksByItem = HashMultimap.create();
    @Nullable
    private IStorageDiskListener listener;
    private IStorageDiskContainerContext context;

    public StorageDiskItem(@Nullable World world, long capacity) {
        this.world = world;
        this.capacity = capacity;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (StackListEntry<ItemStack> entry : this.stacks.values()) {
            NBTTagCompound stackTag = StackUtils.serializeStackToNbt(entry.getStack());
            stackTag.func_74772_a(NBT_REAL_SIZE, entry.getCount());
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74778_a(NBT_VERSION, "2.3.2");
        tag.func_74782_a(NBT_ITEMS, (NBTBase)list);
        tag.func_74772_a(NBT_CAPACITY, this.capacity);
        return tag;
    }

    @Override
    public String getId() {
        return "normal_item";
    }

    @Override
    public Collection<StackListEntry<ItemStack>> getEntries() {
        return this.stacks.values();
    }

    @Override
    @Nullable
    public StackListResult<ItemStack> insert(@Nonnull ItemStack stack, long size, Action action) {
        StackListItem.ItemStackWrapper wrapper = new StackListItem.ItemStackWrapper(stack);
        StackListEntry<ItemStack> entry = this.stacks.get(wrapper);
        if (entry != null) {
            if (this.getCapacity() != -1L && this.getStored() + size > this.getCapacity()) {
                long remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0L) {
                    return new StackListResult<ItemStack>(stack.func_77946_l(), size);
                }
                if (action == Action.PERFORM) {
                    entry.grow(remainingSpace);
                    this.stored += remainingSpace;
                    this.onChanged();
                }
                return new StackListResult<ItemStack>(entry.getStack().func_77946_l(), size - remainingSpace);
            }
            if (action == Action.PERFORM) {
                entry.grow(size);
                this.stored += size;
                this.onChanged();
            }
            return null;
        }
        if (this.getCapacity() != -1L && this.getStored() + size > this.getCapacity()) {
            long remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0L) {
                return new StackListResult<ItemStack>(stack.func_77946_l(), size);
            }
            if (action == Action.PERFORM) {
                ItemStack newStack = stack.func_77946_l();
                wrapper.setStack(newStack);
                this.stacks.put(wrapper, new StackListEntry<ItemStack>(newStack, remainingSpace));
                this.stacksByItem.put((Object)stack.func_77973_b(), (Object)new StackListItem.ItemStackWrapper(newStack));
                this.stored += remainingSpace;
                this.onChanged();
            }
            return new StackListResult<ItemStack>(stack.func_77946_l(), size - remainingSpace);
        }
        if (action == Action.PERFORM) {
            ItemStack newStack = stack.func_77946_l();
            wrapper.setStack(newStack);
            this.stacks.put(wrapper, new StackListEntry<ItemStack>(newStack, size));
            this.stacksByItem.put((Object)stack.func_77973_b(), (Object)new StackListItem.ItemStackWrapper(newStack));
            this.stored += size;
            this.onChanged();
        }
        return null;
    }

    @Override
    @Nullable
    public StackListResult<ItemStack> extract(@Nonnull ItemStack stack, long size, int flags, Action action) {
        if ((flags & 2) == 2 && (flags & 1) == 1 && (flags & 8) != 8) {
            StackListItem.ItemStackWrapper wrapper = new StackListItem.ItemStackWrapper(stack);
            StackListEntry<ItemStack> entry = this.stacks.get(wrapper);
            if (entry == null) {
                return null;
            }
            if (size > entry.getCount()) {
                size = entry.getCount();
            }
            if (action == Action.PERFORM) {
                if (entry.getCount() - size == 0L) {
                    this.stacks.remove(wrapper);
                    this.stacksByItem.remove((Object)stack.func_77973_b(), (Object)new StackListItem.ItemStackWrapper(stack));
                    this.stored -= entry.getCount();
                } else {
                    entry.shrink(size);
                    this.stored -= size;
                }
                this.onChanged();
            }
            return new StackListResult<ItemStack>(entry.getStack().func_77946_l(), size);
        }
        for (StackListItem.ItemStackWrapper key : this.stacksByItem.get((Object)stack.func_77973_b())) {
            StackListEntry<ItemStack> entry = this.stacks.get(key);
            if (!API.instance().getComparer().isEqual(entry.getStack(), stack, flags)) continue;
            if (size > entry.getCount()) {
                size = entry.getCount();
            }
            if (action == Action.PERFORM) {
                if (entry.getCount() - size == 0L) {
                    this.stacks.remove(key);
                    this.stacksByItem.remove((Object)stack.func_77973_b(), (Object)key);
                    this.stored -= entry.getCount();
                } else {
                    entry.shrink(size);
                    this.stored -= size;
                }
                this.onChanged();
            }
            return new StackListResult<ItemStack>(entry.getStack().func_77946_l(), size);
        }
        return null;
    }

    @Override
    public long getStored() {
        return this.stored;
    }

    public void calculateStoredAmount() {
        this.stored = this.stacks.values().stream().mapToLong(StackListEntry::getCount).sum();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.listener = listener;
        this.context = context;
    }

    @Override
    public long getCacheDelta(long storedPreInsertion, long size, long remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0L;
        }
        return remainder < 1L ? size : size - remainder;
    }

    @Deprecated
    public void putRaw(ItemStack stack, long count) {
        this.stacks.put(new StackListItem.ItemStackWrapper(stack), new StackListEntry<ItemStack>(stack, count));
        this.stacksByItem.put((Object)stack.func_77973_b(), (Object)new StackListItem.ItemStackWrapper(stack));
    }

    private void onChanged() {
        if (this.listener != null) {
            this.listener.onChanged();
        }
        if (this.world != null) {
            API.instance().getStorageDiskManager(this.world).markForSaving();
        }
    }
}

