/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk.factory;

import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskFactory;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskItem;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class StorageDiskFactoryItem
implements IStorageDiskFactory<ItemStack> {
    public static final String ID = "normal_item";

    @Override
    public IStorageDisk<ItemStack> createFromNbt(World world, NBTTagCompound tag) {
        StorageDiskItem disk = new StorageDiskItem(world, tag.func_74763_f("Capacity"));
        NBTTagList list = (NBTTagList)tag.func_74781_a("Items");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            ItemStack stack = StackUtils.deserializeStackFromNbt(stackTag);
            long realCount = !stackTag.func_74764_b("RealSize") ? (long)stack.func_190916_E() : stackTag.func_74763_f("RealSize");
            if (stack.func_190926_b()) continue;
            disk.putRaw(stack, realCount);
        }
        disk.calculateStoredAmount();
        return disk;
    }

    @Override
    public IStorageDisk<ItemStack> create(World world, int capacity) {
        return new StorageDiskItem(world, capacity);
    }
}

