/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ExternalStorageCacheFluid {
    private List<StackListEntry<FluidStack>> cache;

    public void update(INetwork network, @Nullable IFluidHandler handler, List<StackListEntry<FluidStack>> entries) {
        int i;
        if (handler == null) {
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<StackListEntry<FluidStack>>();
            for (StackListEntry<FluidStack> entry : entries) {
                FluidStack stack = entry.getStack();
                if (stack != null) {
                    stack = stack.copy();
                }
                this.cache.add(new StackListEntry<FluidStack>(stack, entry.getCount()));
            }
            return;
        }
        for (i = 0; i < entries.size(); ++i) {
            StackListEntry<FluidStack> actual = entries.get(i);
            FluidStack actualStack = actual.getStack();
            if (i >= this.cache.size()) {
                if (actualStack == null) continue;
                network.getFluidStorageCache().add(actualStack, actual.getCount(), true);
                this.cache.add(new StackListEntry<FluidStack>(actualStack.copy(), actual.getCount()));
                continue;
            }
            StackListEntry<FluidStack> cached = this.cache.get(i);
            FluidStack cachedStack = cached.getStack();
            if (actualStack == null && cachedStack == null) continue;
            if (actualStack == null) {
                network.getFluidStorageCache().remove(cachedStack, cached.getCount(), true);
                this.cache.set(i, null);
                continue;
            }
            if (cachedStack == null) {
                network.getFluidStorageCache().add(actualStack, actual.getCount(), true);
                this.cache.set(i, new StackListEntry<FluidStack>(actualStack.copy(), actual.getCount()));
                continue;
            }
            if (!API.instance().getComparer().isEqual(actualStack, cachedStack, 2)) {
                network.getFluidStorageCache().remove(cachedStack, cached.getCount(), true);
                network.getFluidStorageCache().add(actualStack, actual.getCount(), true);
                this.cache.set(i, new StackListEntry<FluidStack>(actualStack.copy(), actual.getCount()));
                continue;
            }
            if (actual.getCount() > cached.getCount()) {
                network.getFluidStorageCache().add(actualStack, actual.getCount() - cached.getCount(), true);
                cached.setCount(actual.getCount());
                continue;
            }
            if (actual.getCount() >= cached.getCount()) continue;
            network.getFluidStorageCache().remove(actualStack, cached.getCount() - actual.getCount(), true);
            cached.setCount(actual.getCount());
        }
        if (this.cache.size() > entries.size()) {
            for (i = this.cache.size() - 1; i >= handler.getTankProperties().length; --i) {
                StackListEntry<FluidStack> cached = this.cache.get(i);
                FluidStack cachedStack = cached.getStack();
                if (cachedStack != null) {
                    network.getFluidStorageCache().remove(cachedStack, cached.getCount(), true);
                }
                this.cache.remove(i);
            }
        }
        network.getFluidStorageCache().flush();
    }
}

