/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ExternalStorageCacheItem {
    private List<StackListEntry<ItemStack>> cache;

    public void update(INetwork network, @Nullable IItemHandler handler, List<StackListEntry<ItemStack>> entries) {
        int i;
        if (handler == null) {
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<StackListEntry<ItemStack>>();
            for (StackListEntry<ItemStack> entry : entries) {
                this.cache.add(new StackListEntry<ItemStack>(entry.getStack().func_77946_l(), entry.getCount()));
            }
            return;
        }
        for (i = 0; i < entries.size(); ++i) {
            StackListEntry<ItemStack> actual = entries.get(i);
            ItemStack actualStack = actual.getStack();
            if (i >= this.cache.size()) {
                if (actualStack.func_190926_b()) continue;
                network.getItemStorageCache().add(actualStack, actual.getCount(), true);
                this.cache.add(new StackListEntry<ItemStack>(actualStack.func_77946_l(), actual.getCount()));
                continue;
            }
            StackListEntry<ItemStack> cached = this.cache.get(i);
            ItemStack cachedStack = cached.getStack();
            if (!cachedStack.func_190926_b() && actualStack.func_190926_b()) {
                network.getItemStorageCache().remove(cachedStack, cached.getCount(), true);
                this.cache.set(i, new StackListEntry<ItemStack>(ItemStack.field_190927_a, 0L));
                continue;
            }
            if (cachedStack.func_190926_b() && !actualStack.func_190926_b()) {
                network.getItemStorageCache().add(actualStack, actual.getCount(), true);
                this.cache.set(i, new StackListEntry<ItemStack>(actualStack.func_77946_l(), actual.getCount()));
                continue;
            }
            if (!API.instance().getComparer().isEqualNoQuantity(cachedStack, actualStack)) {
                network.getItemStorageCache().remove(cachedStack, cached.getCount(), true);
                network.getItemStorageCache().add(actualStack, actual.getCount(), true);
                this.cache.set(i, new StackListEntry<ItemStack>(actualStack.func_77946_l(), actual.getCount()));
                continue;
            }
            if (cached.getCount() == actual.getCount()) continue;
            long delta = actual.getCount() - cached.getCount();
            if (delta > 0L) {
                network.getItemStorageCache().add(actualStack, delta, true);
            } else {
                network.getItemStorageCache().remove(actualStack, Math.abs(delta), true);
            }
            cached.grow(delta);
        }
        if (this.cache.size() > entries.size()) {
            for (i = this.cache.size() - 1; i >= handler.getSlots(); --i) {
                StackListEntry<ItemStack> cached = this.cache.get(i);
                ItemStack cachedStack = cached.getStack();
                if (!cachedStack.func_190926_b()) {
                    network.getItemStorageCache().remove(cachedStack, cached.getCount(), true);
                }
                this.cache.remove(i);
            }
        }
        network.getItemStorageCache().flush();
    }
}

