/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.cjm721.overloaded.storage.LongItemStack;
import com.cjm721.overloaded.storage.item.LongItemStorage;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage.ExternalStorageCacheItem;
import com.raoulvdberge.refinedstorage.integration.overloaded.IntegrationOverloaded;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageExternalItem
implements IStorageExternal<ItemStack> {
    private final IExternalStorageContext context;
    private final Supplier<IItemHandler> handlerSupplier;
    private final boolean connectedToInterface;
    private final ExternalStorageCacheItem cache = new ExternalStorageCacheItem();

    public StorageExternalItem(IExternalStorageContext context, Supplier<IItemHandler> handlerSupplier, boolean connectedToInterface) {
        this.context = context;
        this.handlerSupplier = handlerSupplier;
        this.connectedToInterface = connectedToInterface;
    }

    public boolean isConnectedToInterface() {
        return this.connectedToInterface;
    }

    @Override
    public void update(INetwork network) {
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        this.cache.update(network, this.handlerSupplier.get(), (List)this.getEntries());
    }

    @Override
    public long getCapacity() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return 0L;
        }
        long capacity = 0L;
        if (IntegrationOverloaded.isLoaded() && handler instanceof LongItemStorage) {
            return Long.MAX_VALUE;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            capacity += (long)handler.getSlotLimit(i);
        }
        return capacity;
    }

    @Override
    public Collection<StackListEntry<ItemStack>> getEntries() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return Collections.emptyList();
        }
        ArrayList<StackListEntry<ItemStack>> list = new ArrayList<StackListEntry<ItemStack>>();
        if (IntegrationOverloaded.isLoaded() && handler instanceof LongItemStorage) {
            LongItemStorage longItemStorage = (LongItemStorage)handler;
            LongItemStack longItemStack = longItemStorage.status();
            list.add(new StackListEntry<ItemStack>(longItemStack.getItemStack(), longItemStack.getAmount()));
            return list;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            list.add(new StackListEntry<ItemStack>(stack, stack.func_190916_E()));
        }
        return list;
    }

    @Override
    @Nullable
    public StackListResult<ItemStack> insert(@Nonnull ItemStack stack, long size, Action action) {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler != null && this.context.acceptsItem(stack)) {
            ItemStack result = StackUtils.emptyToNull(ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)((int)size)), (action == Action.SIMULATE ? 1 : 0) != 0));
            if (result == null) {
                return null;
            }
            return new StackListResult<ItemStack>(result, result.func_190916_E());
        }
        return new StackListResult<ItemStack>(stack.func_77946_l(), size);
    }

    @Override
    @Nullable
    public StackListResult<ItemStack> extract(@Nonnull ItemStack stack, long size, int flags, Action action) {
        int remaining = (int)size;
        ItemStack received = null;
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return null;
        }
        block0: for (int i = 0; i < handler.getSlots(); ++i) {
            boolean shouldLoop;
            ItemStack slot = handler.getStackInSlot(i);
            if (slot.func_190926_b() || !API.instance().getComparer().isEqual(slot, stack, flags)) continue;
            int countInSlot = slot.func_190916_E();
            ItemStack got = handler.extractItem(i, remaining, action == Action.SIMULATE);
            boolean bl = shouldLoop = got.func_190916_E() < remaining && got.func_190916_E() != countInSlot;
            while (!got.func_190926_b()) {
                if (received == null) {
                    received = got.func_77946_l();
                } else {
                    received.func_190917_f(got.func_190916_E());
                }
                if ((remaining -= got.func_190916_E()) <= 0) break block0;
                if (!shouldLoop) continue block0;
                got = handler.extractItem(i, remaining, action == Action.SIMULATE);
            }
        }
        return received == null ? null : new StackListResult<Object>(received, received.func_190916_E());
    }

    @Override
    public long getStored() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return 0L;
        }
        if (IntegrationOverloaded.isLoaded() && handler instanceof LongItemStorage) {
            return ((LongItemStorage)handler).status().getAmount();
        }
        int size = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            size += handler.getStackInSlot(i).func_190916_E();
        }
        return size;
    }

    @Override
    public int getPriority() {
        return this.context.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public long getCacheDelta(long storedPreInsertion, long size, long remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0L;
        }
        return remainder < 1L ? size : size - remainder;
    }
}

