/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.tracker;

import com.raoulvdberge.refinedstorage.api.storage.tracker.IStorageTracker;
import com.raoulvdberge.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StorageTrackerItem
implements IStorageTracker<ItemStack> {
    private static final String NBT_STACK = "Stack";
    private static final String NBT_NAME = "Name";
    private static final String NBT_TIME = "Time";
    private final Map<Key, StorageTrackerEntry> changes = new HashMap<Key, StorageTrackerEntry>();
    private final Runnable listener;

    public StorageTrackerItem(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void changed(EntityPlayer player, ItemStack stack) {
        this.changes.put(new Key(stack), new StorageTrackerEntry(System.currentTimeMillis(), player.func_70005_c_()));
        this.listener.run();
    }

    @Override
    public StorageTrackerEntry get(ItemStack stack) {
        return this.changes.get(new Key(stack));
    }

    public void readFromNbt(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack stack = new ItemStack(tag.func_74775_l(NBT_STACK));
            if (stack.func_190926_b()) continue;
            this.changes.put(new Key(stack), new StorageTrackerEntry(tag.func_74763_f(NBT_TIME), tag.func_74779_i(NBT_NAME)));
        }
    }

    public NBTTagList serializeNbt() {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Key, StorageTrackerEntry> entry : this.changes.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a(NBT_TIME, entry.getValue().getTime());
            tag.func_74778_a(NBT_NAME, entry.getValue().getName());
            tag.func_74782_a(NBT_STACK, (NBTBase)entry.getKey().stack.func_77955_b(new NBTTagCompound()));
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    private static class Key {
        private final ItemStack stack;

        public Key(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object other) {
            return other instanceof Key && API.instance().getComparer().isEqualNoQuantity(this.stack, ((Key)other).stack);
        }

        public int hashCode() {
            return API.instance().getItemStackHashCode(this.stack);
        }
    }
}

