/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.raoulvdberge.refinedstorage.api.util.IQuantityFormatter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class QuantityFormatter
implements IQuantityFormatter {
    private final DecimalFormat formatterWithUnits = new DecimalFormat("####0.#", DecimalFormatSymbols.getInstance(Locale.US));
    private final DecimalFormat formatter = new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(Locale.US));
    private final DecimalFormat bucketFormatter = new DecimalFormat("####0.###", DecimalFormatSymbols.getInstance(Locale.US));

    public QuantityFormatter() {
        this.formatterWithUnits.setRoundingMode(RoundingMode.DOWN);
    }

    @Override
    public String formatWithUnits(long qty) {
        if (qty >= 1000000000000L) {
            return this.formatterWithUnits.format((double)qty / 1.0E12) + "T";
        }
        if (qty >= 1000000000L) {
            return this.formatterWithUnits.format((double)qty / 1.0E9) + "B";
        }
        if (qty >= 1000000L) {
            double qtyShort = (double)qty / 1000000.0;
            if (qty >= 100000000L) {
                qtyShort = Math.floor(qtyShort);
            }
            return this.formatterWithUnits.format(qtyShort) + "M";
        }
        if (qty >= 1000L) {
            double qtyShort = (double)qty / 1000.0;
            if (qty >= 100000L) {
                qtyShort = Math.floor(qtyShort);
            }
            return this.formatterWithUnits.format(qtyShort) + "K";
        }
        return String.valueOf(qty);
    }

    @Override
    public String format(long qty) {
        return this.formatter.format(qty);
    }

    @Override
    public String formatInBucketForm(long qty) {
        return this.bucketFormatter.format((double)qty / 1000.0) + " B";
    }

    @Override
    public String formatInBucketFormWithOnlyTrailingDigitsIfZero(long qty) {
        double amountRaw = (double)qty / 1000.0;
        long amount = (long)amountRaw;
        if (amount >= 1L) {
            return API.instance().getQuantityFormatter().formatWithUnits(amount);
        }
        return String.format("%.1f", amountRaw);
    }
}

