/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.block.BlockNode;
import com.raoulvdberge.refinedstorage.block.info.BlockDirection;
import com.raoulvdberge.refinedstorage.block.info.BlockInfoBuilder;
import com.raoulvdberge.refinedstorage.block.property.PropertyObject;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.model.ModelDiskManipulator;
import com.raoulvdberge.refinedstorage.render.model.loader.CustomModelLoaderDefault;
import com.raoulvdberge.refinedstorage.tile.TileDiskManipulator;
import javax.annotation.Nonnull;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDiskManipulator
extends BlockNode {
    public static final PropertyObject<Integer[]> DISK_STATE = new PropertyObject<Integer[]>("disk_state", Integer[].class);

    public BlockDiskManipulator() {
        super(BlockInfoBuilder.forId("disk_manipulator").tileEntity(TileDiskManipulator::new).create());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "inventory"));
        modelRegistration.addModelLoader(() -> new CustomModelLoaderDefault(this.info.getId(), ModelDiskManipulator::new));
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @Nonnull
    public BlockDirection getDirection() {
        return BlockDirection.HORIZONTAL;
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.openNetworkGui(18, player, world, pos, side);
    }

    @Override
    protected BlockStateContainer.Builder createBlockStateBuilder() {
        return super.createBlockStateBuilder().add(new IUnlistedProperty[]{DISK_STATE});
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockState s = super.getExtendedState(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDiskManipulator) {
            s = ((IExtendedBlockState)s).withProperty(DISK_STATE, (Object)((TileDiskManipulator)tile).getDiskState());
        }
        return s;
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }
}

