/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.block.BlockNodeProxy;
import com.raoulvdberge.refinedstorage.block.info.IBlockInfo;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockNode
extends BlockNodeProxy {
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");

    public BlockNode(IBlockInfo info) {
        super(info);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileNode && placer instanceof EntityPlayer) {
                ((NetworkNode)((TileNode)tile).getNode()).setOwner(((EntityPlayer)placer).func_146103_bH().getId());
            }
            API.instance().discoverNode(world, pos);
        }
    }

    @Override
    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        INetworkNodeManager manager = API.instance().getNetworkNodeManager(world);
        INetworkNode node = manager.getNode(pos);
        this.dropContents(world, pos);
        this.removeTile(world, pos, state);
        manager.removeNode(pos);
        manager.markForSaving();
        if (node != null && node.getNetwork() != null) {
            node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, node.getNetwork().world(), node.getNetwork().getPosition());
        }
    }

    @Override
    protected BlockStateContainer.Builder createBlockStateBuilder() {
        BlockStateContainer.Builder builder = super.createBlockStateBuilder();
        if (this.hasConnectedState()) {
            builder.add(new IProperty[]{CONNECTED});
        }
        return builder;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().build();
    }

    @Override
    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity tile;
        state = super.func_176221_a(state, world, pos);
        if (this.hasConnectedState() && (tile = world.func_175625_s(pos)) instanceof TileNode) {
            return state.func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(((NetworkNode)((TileNode)tile).getNode()).isActive()));
        }
        return state;
    }

    public boolean hasConnectedState() {
        return false;
    }
}

