/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeExporter;
import com.raoulvdberge.refinedstorage.container.ContainerBase;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilter;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilterFluid;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileExporter;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerExporter
extends ContainerBase {
    private boolean hasRegulatorUpgrade;
    private final TileExporter exporter;

    public ContainerExporter(TileExporter exporter, EntityPlayer player) {
        super(exporter, player);
        this.exporter = exporter;
        this.hasRegulatorUpgrade = this.hasRegulatorUpgrade();
        this.initSlots();
    }

    private boolean hasRegulatorUpgrade() {
        return ((NetworkNodeExporter)this.exporter.getNode()).getUpgradeHandler().hasUpgrade(10);
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        this.detectRegulatorUpgradeChange();
        super.func_75141_a(slotID, stack);
    }

    @Override
    @Nonnull
    public ItemStack func_184996_a(int id, int dragType, @Nonnull ClickType clickType, @Nonnull EntityPlayer player) {
        this.detectRegulatorUpgradeChange();
        return super.func_184996_a(id, dragType, clickType, player);
    }

    private void detectRegulatorUpgradeChange() {
        boolean newState = this.hasRegulatorUpgrade();
        if (this.hasRegulatorUpgrade != newState) {
            this.hasRegulatorUpgrade = newState;
            this.initSlots();
        }
    }

    public void initSlots() {
        int i;
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.transferManager.clearTransfers();
        TileExporter exporter = (TileExporter)this.getTile();
        ItemHandlerUpgrade upgrades = ((NetworkNodeExporter)exporter.getNode()).getUpgradeHandler();
        for (i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)upgrades, i, 187, 6 + i * 18));
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotFilter((IItemHandler)((NetworkNodeExporter)exporter.getNode()).getConfig().getItemHandler(), i, 8 + 18 * i, 20, upgrades.hasUpgrade(10) ? 1 : 0).setEnableHandler(() -> ((NetworkNodeExporter)exporter.getNode()).getConfig().isFilterTypeItem()));
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotFilterFluid(((NetworkNodeExporter)exporter.getNode()).getConfig().getFluidHandler(), i, 8 + 18 * i, 20, upgrades.hasUpgrade(10) ? 1 : 0).setEnableHandler(() -> ((NetworkNodeExporter)exporter.getNode()).getConfig().isFilterTypeFluid()));
        }
        this.addPlayerInventory(8, 55);
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, (IItemHandler)upgrades);
        this.transferManager.addFilterTransfer((IInventory)this.getPlayer().field_71071_by, ((NetworkNodeExporter)exporter.getNode()).getConfig().getItemHandler(), ((NetworkNodeExporter)exporter.getNode()).getConfig().getFluidHandler(), ((NetworkNodeExporter)exporter.getNode()).getConfig()::getFilterType);
    }
}

