/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingMonitor;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.gui.control.TabList;
import com.raoulvdberge.refinedstorage.network.MessageCraftingCancel;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCraftingMonitor
extends GuiBase {
    private static final int ROWS = 5;
    private static final int ITEM_WIDTH = 73;
    private static final int ITEM_HEIGHT = 29;
    private GuiButton cancelButton;
    private GuiButton cancelAllButton;
    private final ICraftingMonitor craftingMonitor;
    private List<IGridTab> tasks = Collections.emptyList();
    private final TabList tabs;
    private final IElementDrawers drawers = new CraftingMonitorElementDrawers();

    public GuiCraftingMonitor(ContainerCraftingMonitor container, final ICraftingMonitor craftingMonitor) {
        super(container, 254, 201);
        this.craftingMonitor = craftingMonitor;
        this.tabs = new TabList(this, new GuiBase.ElementDrawers(), () -> this.tasks, () -> (int)Math.floor((float)Math.max(0, this.tasks.size() - 1) / 7.0f), craftingMonitor::getTabPage, () -> {
            IGridTab tab = this.getCurrentTab();
            if (tab == null) {
                return -1;
            }
            return this.tasks.indexOf(tab);
        }, 7);
        this.tabs.addListener(new TabList.ITabListListener(){

            @Override
            public void onSelectionChanged(int tab) {
                craftingMonitor.onTabSelectionChanged((Optional<UUID>)Optional.of((Object)((CraftingMonitorTask)GuiCraftingMonitor.this.tasks.get(tab)).id));
                GuiCraftingMonitor.this.scrollbar.setOffset(0);
            }

            @Override
            public void onPageChanged(int page) {
                craftingMonitor.onTabPageChanged(page);
            }
        });
    }

    public void setTasks(List<IGridTab> tasks) {
        this.tasks = tasks;
    }

    public List<ICraftingMonitorElement> getElements() {
        if (!this.craftingMonitor.isActive()) {
            return Collections.emptyList();
        }
        IGridTab tab = this.getCurrentTab();
        if (tab == null) {
            return Collections.emptyList();
        }
        return ((CraftingMonitorTask)tab).elements;
    }

    @Override
    public void init(int x, int y) {
        this.tabs.init(this.field_146999_f);
        this.scrollbar = new Scrollbar(235, 20, 12, 149);
        if (this.craftingMonitor.getRedstoneModeParameter() != null) {
            this.addSideButton(new SideButtonRedstoneMode(this, this.craftingMonitor.getRedstoneModeParameter()));
        }
        String cancel = GuiCraftingMonitor.t("gui.cancel", new Object[0]);
        String cancelAll = GuiCraftingMonitor.t("misc.refinedstorage:cancel_all", new Object[0]);
        int cancelButtonWidth = 14 + this.field_146289_q.func_78256_a(cancel);
        int cancelAllButtonWidth = 14 + this.field_146289_q.func_78256_a(cancelAll);
        this.cancelButton = this.addButton(x + 7, y + 201 - 20 - 7, cancelButtonWidth, 20, cancel, false, true);
        this.cancelAllButton = this.addButton(x + 7 + cancelButtonWidth + 4, y + 201 - 20 - 7, cancelAllButtonWidth, 20, cancelAll, false, true);
    }

    private void updateScrollbar() {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 5);
            this.scrollbar.setMaxOffset(this.getRows() - 5);
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.getElements().size() / 3.0f));
    }

    @Override
    public void update(int x, int y) {
        this.updateScrollbar();
        this.tabs.update();
        if (this.cancelButton != null) {
            this.cancelButton.field_146124_l = this.hasValidTabSelected();
        }
        if (this.cancelAllButton != null) {
            this.cancelAllButton.field_146124_l = !this.tasks.isEmpty();
        }
    }

    private boolean hasValidTabSelected() {
        return this.getCurrentTab() != null;
    }

    @Nullable
    private IGridTab getCurrentTab() {
        IGridTab tab;
        Optional<UUID> currentTab = this.craftingMonitor.getTabSelected();
        if (currentTab.isPresent() && (tab = this.getTabById((UUID)currentTab.get())) != null) {
            return tab;
        }
        if (this.tasks.isEmpty()) {
            return null;
        }
        return this.tasks.get(0);
    }

    @Nullable
    private IGridTab getTabById(UUID id) {
        return this.tasks.stream().filter(t -> ((CraftingMonitorTask)t).id.equals(id)).findFirst().orElse(null);
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        if (this.craftingMonitor.isActive()) {
            this.tabs.drawBackground(x, y - this.tabs.getHeight());
        }
        this.bindTexture("gui/crafting_preview.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        this.tabs.drawForeground(x, y - this.tabs.getHeight(), mouseX, mouseY, this.craftingMonitor.isActive());
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiCraftingMonitor.t(this.craftingMonitor.getGuiTitle(), new Object[0]));
        int item = this.scrollbar != null ? this.scrollbar.getOffset() * 3 : 0;
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        int x = 7;
        int y = 20;
        String itemSelectedTooltip = null;
        for (int i = 0; i < 15; ++i) {
            if (item < this.getElements().size()) {
                ICraftingMonitorElement element = this.getElements().get(item);
                element.draw(x, y, this.drawers);
                if (this.inBounds(x, y, 73, 29, mouseX, mouseY)) {
                    itemSelectedTooltip = element.getTooltip();
                }
                if ((i + 1) % 3 == 0) {
                    x = 7;
                    y += 30;
                } else {
                    x += 74;
                }
            }
            ++item;
        }
        if (itemSelectedTooltip != null && !itemSelectedTooltip.isEmpty()) {
            this.drawTooltip(mouseX, mouseY, I18n.func_135052_a((String)itemSelectedTooltip, (Object[])new Object[0]));
        }
        this.tabs.drawTooltip(this.field_146289_q, mouseX, mouseY);
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.tabs.actionPerformed(button);
        if (this.getCurrentTab() == null) {
            return;
        }
        if (button == this.cancelButton && this.hasValidTabSelected()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageCraftingCancel(((CraftingMonitorTask)this.getCurrentTab()).id));
        } else if (button == this.cancelAllButton && !this.tasks.isEmpty()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageCraftingCancel(null));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.tabs.mouseClicked();
    }

    public static class CraftingMonitorTask
    implements IGridTab {
        private final UUID id;
        private final ICraftingRequestInfo requested;
        private final long qty;
        private final long executionTime;
        private final int completionPercentage;
        private final List<ICraftingMonitorElement> elements;

        public CraftingMonitorTask(UUID id, ICraftingRequestInfo requested, long qty, long executionTime, int completionPercentage, List<ICraftingMonitorElement> elements) {
            this.id = id;
            this.requested = requested;
            this.qty = qty;
            this.executionTime = executionTime;
            this.completionPercentage = completionPercentage;
            this.elements = elements;
        }

        @Override
        @Nullable
        public List<IFilter<?>> getFilters() {
            return null;
        }

        @Override
        public void drawTooltip(int x, int y, int screenWidth, int screenHeight, FontRenderer fontRenderer) {
            ArrayList textLines = Lists.newArrayList((Object[])new String[]{this.requested.getItem() != null ? this.requested.getItem().func_82833_r() : this.requested.getFluid().getLocalizedName()});
            ObjectArrayList smallTextLines = new ObjectArrayList();
            int totalSecs = (int)(this.executionTime / 1000L);
            int seconds = totalSecs % 60;
            int minutes = totalSecs / 60 % 60;
            int hours = totalSecs / 3600 % 24;
            int days = totalSecs / 86400;
            smallTextLines.add(I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.tooltip.requested", (Object[])new Object[]{this.requested.getFluid() != null ? API.instance().getQuantityFormatter().formatInBucketForm(this.qty) : API.instance().getQuantityFormatter().format(this.qty)}));
            if (this.executionTime == -1L) {
                smallTextLines.add("Pending");
            } else {
                if (hours > 0) {
                    smallTextLines.add(String.format("%02d:%02d:%02d:%02d", days, hours, minutes, seconds));
                } else {
                    smallTextLines.add(String.format("%02d:%02d", minutes, seconds));
                }
                smallTextLines.add(String.format("%d%%", this.completionPercentage));
            }
            RenderUtils.drawTooltipWithSmallText(textLines, (List<String>)smallTextLines, true, ItemStack.field_190927_a, x, y, screenWidth, screenHeight, fontRenderer);
        }

        @Override
        public void drawIcon(int x, int y, IElementDrawer<ItemStack> itemDrawer, IElementDrawer<FluidStack> fluidDrawer) {
            if (this.requested.getItem() != null) {
                RenderHelper.func_74520_c();
                itemDrawer.draw(x, y, this.requested.getItem());
            } else {
                fluidDrawer.draw(x, y, this.requested.getFluid());
                GlStateManager.func_179141_d();
            }
        }
    }

    public class CraftingMonitorElementDrawers
    extends GuiBase.ElementDrawers {
        private final IElementDrawer<Integer> overlayDrawer = (x, y, color) -> {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            Gui.func_73734_a((int)x, (int)y, (int)(x + 73), (int)(y + 29), (int)color);
        };
        private final IElementDrawer<?> errorDrawer = (x, y, nothing) -> {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GuiCraftingMonitor.this.bindTexture("gui/crafting_preview.png");
            GuiCraftingMonitor.this.drawTexture(x + 2, y + 2, 0, 244, 12, 12);
        };

        @Override
        public IElementDrawer<Integer> getOverlayDrawer() {
            return this.overlayDrawer;
        }

        @Override
        public IElementDrawer<?> getErrorDrawer() {
            return this.errorDrawer;
        }
    }
}

