/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.control;

import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.SideButton;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.util.text.TextFormatting;

public class SideButtonCompare
extends SideButton {
    private final TileDataParameter<Integer, ?> parameter;
    private final int mask;

    public SideButtonCompare(GuiBase gui, TileDataParameter<Integer, ?> parameter, int mask) {
        super(gui);
        this.parameter = parameter;
        this.mask = mask;
    }

    @Override
    public String getTooltip() {
        String tooltip = GuiBase.t("sidebutton.refinedstorage:compare." + this.mask, new Object[0]) + "\n" + TextFormatting.GRAY;
        tooltip = (this.parameter.getValue() & this.mask) == this.mask ? tooltip + GuiBase.t("gui.yes", new Object[0]) : tooltip + GuiBase.t("gui.no", new Object[0]);
        return tooltip;
    }

    @Override
    protected void drawButtonIcon(int x, int y) {
        int ty = 0;
        if (this.mask == 1) {
            ty = 80;
        } else if (this.mask == 2) {
            ty = 48;
        }
        int tx = (this.parameter.getValue() & this.mask) == this.mask ? 0 : 16;
        this.gui.drawTexture(x, y, tx, ty, 16, 16);
    }

    @Override
    public void actionPerformed() {
        TileDataManager.setParameter(this.parameter, this.parameter.getValue() ^ this.mask);
    }
}

