/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.control;

import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.SideButton;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.util.text.TextFormatting;

public class SideButtonGridSize
extends SideButton {
    private final Supplier<Integer> size;
    private final Consumer<Integer> handler;

    public SideButtonGridSize(GuiBase gui, Supplier<Integer> size, Consumer<Integer> handler) {
        super(gui);
        this.size = size;
        this.handler = handler;
    }

    @Override
    public String getTooltip() {
        return GuiBase.t("sidebutton.refinedstorage:grid.size", new Object[0]) + "\n" + TextFormatting.GRAY + GuiBase.t("sidebutton.refinedstorage:grid.size." + this.size.get(), new Object[0]);
    }

    @Override
    protected void drawButtonIcon(int x, int y) {
        int size = this.size.get();
        int tx = 0;
        if (size == 0) {
            tx = 48;
        } else if (size == 2) {
            tx = 16;
        } else if (size == 3) {
            tx = 32;
        }
        this.gui.drawTexture(x, y, 64 + tx, 64, 16, 16);
    }

    @Override
    public void actionPerformed() {
        int size = this.size.get();
        if (size == 0) {
            size = 1;
        } else if (size == 1) {
            size = 2;
        } else if (size == 2) {
            size = 3;
        } else if (size == 3) {
            size = 0;
        }
        this.handler.accept(size);
    }
}

